/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class HurtBySensor<E extends Mob>
extends PredicateSensor<DamageSource, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26381_, MemoryModuleType.f_26382_});

    public HurtBySensor() {
        super((damageSource, entity) -> true);
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.HURT_BY.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        Brain brain = entity.m_6274_();
        DamageSource damageSource = entity.m_21225_();
        if (damageSource == null) {
            BrainUtils.clearMemory(brain, MemoryModuleType.f_26381_);
        } else if (this.predicate().test(damageSource, entity)) {
            LivingEntity attacker2;
            BrainUtils.setMemory(brain, MemoryModuleType.f_26381_, damageSource);
            Entity entity2 = damageSource.m_7639_();
            if (entity2 instanceof LivingEntity && (attacker2 = (LivingEntity)entity2).m_6084_() && attacker2.f_19853_ == ((Mob)entity).f_19853_) {
                BrainUtils.setMemory(brain, MemoryModuleType.f_26382_, attacker2);
            }
        } else {
            BrainUtils.withMemory(brain, MemoryModuleType.f_26382_, attacker -> {
                if (!attacker.m_6084_() || attacker.f_19853_ != entity.f_19853_) {
                    BrainUtils.clearMemory(brain, MemoryModuleType.f_26382_);
                }
            });
        }
    }
}

