/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.client.model.OrbModel;
import owmii.powah.client.model.PowahLayerDefinitions;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.util.math.V3d;

public class EnergizingOrbRenderer
extends AbstractTileRenderer<EnergizingOrbTile> {
    private final OrbModel model;

    protected EnergizingOrbRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new OrbModel(context.m_173582_(PowahLayerDefinitions.ORB));
    }

    @Override
    public void render(EnergizingOrbTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        Inventory inv = te.getInventory();
        if (!inv.isEmpty()) {
            float ticks = ((float)te.ticks + pt) / 200.0f;
            ItemStack output = inv.getStackInSlot(0);
            if (!output.m_41619_()) {
                matrix.m_85836_();
                matrix.m_85837_(0.5, 0.6, 0.5);
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(-ticks * 360.0f));
                matrix.m_85841_(0.35f, 0.35f, 0.35f);
                mc.m_91291_().m_174269_(output, ItemTransforms.TransformType.FIXED, light, ov, matrix, rtb, 0);
                matrix.m_85849_();
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inv.getNonEmptyStacks());
                List<V3d> circled = V3d.from(Vec3.f_82478_).circled(stacks.size(), 0.1);
                for (int i = 0; i < circled.size(); ++i) {
                    V3d v3d1 = circled.get(i);
                    ItemStack stack = (ItemStack)stacks.get(i);
                    if (stack.m_41619_()) continue;
                    matrix.m_85836_();
                    if (stacks.size() == 1) {
                        matrix.m_85837_(0.5, 0.6, 0.5);
                    } else {
                        matrix.m_85837_(v3d1.f_82479_ + 0.5, v3d1.f_82480_ + 0.6, v3d1.f_82481_ + 0.5);
                    }
                    matrix.m_85841_(0.35f, 0.35f, 0.35f);
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(-ticks * 360.0f));
                    mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, light, ov, matrix, rtb, 0);
                    matrix.m_85849_();
                }
            }
        }
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        matrix.m_85845_(te.getOrbUp().m_122406_());
        matrix.m_85837_(0.0, 0.1, 0.0);
        matrix.m_85841_(1.8f, 1.8f, 1.8f);
        this.model.render(te, this, matrix, rtb, light, ov);
        matrix.m_85849_();
    }
}

