/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld.volcano;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class VolcanoFeature
extends Feature<SimpleBlockProviderConfig> {
    FastNoiseLite fnlPerlin = null;

    public VolcanoFeature(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double baseRadius = 10.0;
        double leakage = 0.5;
        int volcanoConeSize = 30;
        int volcanoStartHeight = volcanoConeSize - 5;
        double threshold = 0.4;
        int fluidY = -20 + rand.m_188503_(9);
        for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
            for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + volcanoStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (scaledNoise - leakage >= threshold) {
                        if (!(y <= (double)fluidY)) continue;
                        while (!world.m_8055_((BlockPos)mutable).m_60815_() && mutable.m_123342_() > world.m_141937_()) {
                            world.m_7731_((BlockPos)mutable, Blocks.f_49991_.m_49966_(), 2);
                            world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76195_, 0);
                            mutable.m_122173_(Direction.DOWN);
                        }
                        continue;
                    }
                    if (!(scaledNoise >= threshold)) continue;
                    while (!world.m_8055_((BlockPos)mutable).m_60815_() && mutable.m_123342_() > world.m_141937_()) {
                        world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                        mutable.m_122173_(Direction.DOWN);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

