/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntitySpring
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final LazyOptional<IFluidHandler> tank = LazyOptional.of(() -> new InfiniteTank());
    private AABBTicket waterTicket;

    public BlockEntitySpring(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SPRING, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            AABB area = new AABB(this.f_58858_).m_82377_(5.0, 1.0, 5.0);
            this.waterTicket = FarmlandWaterManager.addAABBTicket((Level)this.f_58857_, (AABB)area);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && this.waterTicket != null && this.waterTicket.isValid()) {
            this.waterTicket.invalidate();
            this.waterTicket = null;
        }
        this.tank.invalidate();
    }

    @Override
    public void tick() {
        int level;
        if (this.f_58857_.f_46443_ || this.f_58857_.m_46467_() % 35L != 0L) {
            return;
        }
        BlockPos up = this.f_58858_.m_7494_();
        BlockState upState = this.f_58857_.m_8055_(up);
        if (upState.m_61138_((Property)BlockStateProperties.f_61418_) && (level = ((Integer)upState.m_61143_((Property)BlockStateProperties.f_61418_)).intValue()) < 3 && this.tryConsumeAura(2500)) {
            this.f_58857_.m_46597_(up, (BlockState)upState.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(level + 1)));
            this.f_58857_.m_5594_(null, up, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        int spongeRadius = 2;
        for (int x = -spongeRadius; x <= spongeRadius; ++x) {
            for (int y = -spongeRadius; y <= spongeRadius; ++y) {
                for (int z = -spongeRadius; z <= spongeRadius; ++z) {
                    BlockPos pos = this.f_58858_.m_7918_(x, y, z);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (state.m_60734_() != Blocks.f_50056_ || !this.tryConsumeAura(2500)) continue;
                    this.f_58857_.m_7731_(pos, Blocks.f_50057_.m_49966_(), 2);
                    this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49990_.m_49966_()));
                    return;
                }
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos side = this.f_58858_.m_121945_(dir);
            if (!this.isLava(side, true) || !this.tryConsumeAura(1500)) continue;
            this.f_58857_.m_46597_(side, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)this.f_58857_, (BlockPos)side, (BlockPos)side, (BlockState)Blocks.f_50080_.m_49966_()));
            this.f_58857_.m_46796_(1501, side, 0);
            return;
        }
        BlockPos twoUp = this.f_58858_.m_6630_(2);
        if (this.isLava(twoUp, false) && (this.f_58857_.m_8055_(up).m_60795_() || this.isLava(up, false)) && this.tryConsumeAura(150)) {
            this.f_58857_.m_46597_(up, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)this.f_58857_, (BlockPos)up, (BlockPos)twoUp, (BlockState)Blocks.f_50069_.m_49966_()));
            this.f_58857_.m_46796_(1501, up, 0);
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos twoSide = this.f_58858_.m_5484_(dir, 2);
            BlockPos side = this.f_58858_.m_121945_(dir);
            if (!this.isLava(twoSide, false) || !this.f_58857_.m_8055_(side).m_60795_() && !this.isLava(side, false) || !this.tryConsumeAura(100)) continue;
            this.f_58857_.m_46597_(side, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)this.f_58857_, (BlockPos)side, (BlockPos)twoSide, (BlockState)Blocks.f_50652_.m_49966_()));
            this.f_58857_.m_46796_(1501, side, 0);
            return;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }

    public boolean tryConsumeAura(int amount) {
        if (!this.canUseRightNow(amount)) {
            return false;
        }
        BlockPos pos = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
        IAuraChunk.getAuraChunk(this.f_58857_, pos).drainAura(pos, amount);
        return true;
    }

    private boolean isLava(BlockPos offset, boolean source) {
        FluidState state = this.f_58857_.m_6425_(offset);
        return (!source || state.m_76170_()) && state.m_205070_(FluidTags.f_13132_);
    }

    private class InfiniteTank
    implements IFluidTank,
    IFluidHandler {
        private InfiniteTank() {
        }

        public FluidStack getFluid() {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }

        public int getFluidAmount() {
            return 1000;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_76145_().m_205070_(FluidTags.f_13131_);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drain = Math.min(maxDrain, 1000);
            int auraUsed = Mth.m_14167_((float)((float)drain / 2.0f));
            if (!BlockEntitySpring.this.canUseRightNow(auraUsed)) {
                return FluidStack.EMPTY;
            }
            if (action.execute()) {
                BlockEntitySpring.this.tryConsumeAura(auraUsed);
            }
            return new FluidStack((Fluid)Fluids.f_76193_, drain);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.isFluidValid(resource)) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.isFluidValid(stack);
        }
    }
}

