/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockEntityFieldCreator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockPos connectionOffset;
    public boolean isMain;
    public boolean isCharged;
    private int chargeTimer;

    public BlockEntityFieldCreator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FIELD_CREATOR, pos, state);
    }

    @Override
    public void tick() {
        BlockEntityFieldCreator creator;
        BlockPos connectedPos;
        block15: {
            block14: {
                if (this.f_58857_.f_46443_ || this.f_58857_.m_46467_() % 10L != 0L) {
                    return;
                }
                connectedPos = this.getConnectedPos();
                if (connectedPos == null || !this.f_58857_.m_46749_(connectedPos)) {
                    return;
                }
                BlockEntity other = this.f_58857_.m_7702_(connectedPos);
                if (!this.isCloseEnough(connectedPos) || !(other instanceof BlockEntityFieldCreator)) break block14;
                creator = (BlockEntityFieldCreator)other;
                if (this.f_58858_.equals((Object)((BlockEntityFieldCreator)other).getConnectedPos())) break block15;
            }
            this.connectionOffset = null;
            this.chargeTimer = 0;
            this.isCharged = false;
            this.isMain = false;
            this.sendToClients();
            return;
        }
        if (!this.isMain) {
            return;
        }
        if (this.redstonePower <= 0 && creator.redstonePower <= 0 || !this.canUseRightNow(20)) {
            this.chargeTimer = 0;
            if (this.isCharged) {
                this.isCharged = false;
                this.sendToClients();
                creator.isCharged = false;
                creator.sendToClients();
            }
            return;
        }
        BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 32, this.f_58858_);
        IAuraChunk chunk = IAuraChunk.getAuraChunk(this.f_58857_, spot);
        if (!this.isCharged) {
            this.chargeTimer += 10;
            if (this.chargeTimer >= 150) {
                this.chargeTimer = 0;
                this.isCharged = true;
                this.sendToClients();
                creator.isCharged = true;
                creator.sendToClients();
            }
            chunk.drainAura(spot, 300);
            this.sendParticles();
        } else {
            if (this.f_58857_.m_46467_() % 40L == 0L) {
                chunk.drainAura(spot, 20);
            }
            ItemStack tool = this.getToolUsed(creator);
            Vec3 dist = new Vec3((double)(this.f_58858_.m_123341_() - connectedPos.m_123341_()), (double)(this.f_58858_.m_123342_() - connectedPos.m_123342_()), (double)(this.f_58858_.m_123343_() - connectedPos.m_123343_()));
            double length = dist.m_82553_();
            Vec3 normal = new Vec3(dist.f_82479_ / length, dist.f_82480_ / length, dist.f_82481_ / length);
            for (float i = (float)Mth.m_14107_((double)length); i > 0.0f; i -= 0.5f) {
                FakePlayer fake;
                BlockState state;
                Vec3 scaled = normal.m_82490_((double)i);
                BlockPos pos = connectedPos.m_7918_(Mth.m_14107_((double)(scaled.f_82479_ + 0.5)), Mth.m_14107_((double)(scaled.f_82480_ + 0.5)), Mth.m_14107_((double)(scaled.f_82481_ + 0.5)));
                if (pos.equals((Object)this.f_58858_) || pos.equals((Object)connectedPos) || (state = this.f_58857_.m_8055_(pos)).m_60795_() || !(state.m_60800_((BlockGetter)this.f_58857_, pos) >= 0.0f) || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.f_58857_, pos, state, (Player)(fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_)))))) continue;
                List drops = state.m_60724_(new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81455_, (Object)fake).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81461_, (Object)state).m_78972_(LootContextParams.f_81463_, (Object)(tool.m_41619_() ? new ItemStack((ItemLike)Items.f_42390_) : tool)).m_78984_(LootContextParams.f_81462_, (Object)this.f_58857_.m_7702_(pos)));
                this.f_58857_.m_46961_(pos, false);
                for (ItemStack stack : drops) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)pos, (ItemStack)stack);
                }
                chunk.drainAura(spot, !tool.m_41619_() ? 300 : 100);
                this.sendParticles();
            }
        }
    }

    private ItemStack getToolUsed(BlockEntityFieldCreator other) {
        ItemStack myTool = this.getMyTool();
        ItemStack otherTool = other.getMyTool();
        if (!myTool.m_41619_()) {
            if (!otherTool.m_41619_()) {
                return this.f_58857_.f_46441_.m_188499_() ? myTool : otherTool;
            }
            return myTool;
        }
        return otherTool;
    }

    private ItemStack getMyTool() {
        List<ItemFrame> frames = Helper.getAttachedItemFrames(this.f_58857_, this.f_58858_);
        for (ItemFrame frame : frames) {
            ItemStack stack = frame.m_31822_();
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void sendParticles() {
        for (int j = 0; j < 2; ++j) {
            BlockPos p = j == 0 ? this.f_58858_ : this.getConnectedPos();
            PacketHandler.sendToAllAround(this.f_58857_, p, 32, new PacketParticleStream((float)p.m_123341_() + (float)this.f_58857_.f_46441_.m_188583_() * 3.0f, (float)(p.m_123342_() + 1) + this.f_58857_.f_46441_.m_188501_() * 3.0f, (float)p.m_123343_() + (float)this.f_58857_.f_46441_.m_188583_() * 3.0f, (float)p.m_123341_() + 0.5f, (float)p.m_123342_() + 0.5f, (float)p.m_123343_() + 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.07f + 0.07f, IAuraType.forLevel(this.f_58857_).getColor(), this.f_58857_.f_46441_.m_188501_() + 0.5f));
        }
    }

    public boolean isCloseEnough(BlockPos pos) {
        int range = (Integer)ModConfig.instance.fieldCreatorRange.get() + 1;
        return this.f_58858_.m_123331_((Vec3i)pos) <= (double)(range * range);
    }

    public BlockPos getConnectedPos() {
        if (this.connectionOffset == null) {
            return null;
        }
        return this.f_58858_.m_121955_((Vec3i)this.connectionOffset);
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            if (this.connectionOffset != null) {
                compound.m_128356_("connection", this.connectionOffset.m_121878_());
            }
            compound.m_128379_("main", this.isMain);
            compound.m_128379_("charged", this.isCharged);
            if (type == BlockEntityImpl.SaveType.TILE) {
                compound.m_128405_("timer", this.chargeTimer);
            }
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.connectionOffset = compound.m_128441_("connection") ? BlockPos.m_122022_((long)compound.m_128454_("connection")) : null;
            this.isMain = compound.m_128471_("main");
            this.isCharged = compound.m_128471_("charged");
            if (type == BlockEntityImpl.SaveType.TILE) {
                this.chargeTimer = compound.m_128451_("timer");
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

