/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySlimeSplitGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSlimeSplitGenerator
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockSlimeSplitGenerator() {
        super("slime_split_generator", BlockEntitySlimeSplitGenerator.class, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50374_).m_60978_(2.0f));
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        return new AABB(pos).m_82400_(8.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 5089359;
    }

    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public void onLivingDeath(LivingDeathEvent event) {
            Slime slime;
            LivingEntity entity;
            block5: {
                block4: {
                    entity = event.getEntity();
                    if (!(entity instanceof Slime)) break block4;
                    slime = (Slime)entity;
                    if (!entity.f_19853_.f_46443_) break block5;
                }
                return;
            }
            int size = slime.m_33632_();
            if (size <= 1) {
                return;
            }
            Helper.getBlockEntitiesInArea((LevelAccessor)entity.f_19853_, entity.m_20183_(), 8, tile -> {
                if (!(tile instanceof BlockEntitySlimeSplitGenerator)) {
                    return false;
                }
                BlockEntitySlimeSplitGenerator gen = (BlockEntitySlimeSplitGenerator)tile;
                if (gen.isBusy()) {
                    return false;
                }
                gen.startGenerating(slime);
                return true;
            });
        }
    }
}

