/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFunctionalFlower;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import mythicbotany.functionalflora.base.RenderFunctionalFlower;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.base.tile.BlockBE;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.SetupContext;
import vazkii.botania.xplat.BotaniaConfig;

public class BlockFloatingFunctionalFlower<T extends FunctionalFlowerBase>
extends BlockBE<T> {
    private static final VoxelShape SHAPE = BlockFloatingFunctionalFlower.m_49796_((double)1.6, (double)1.6, (double)1.6, (double)14.4, (double)14.4, (double)14.4);
    private final BlockFunctionalFlower<T> nonFloatingBlock;

    public BlockFloatingFunctionalFlower(ModX mod, Class<T> beClass, BlockFunctionalFlower<T> nonFloatingBlock) {
        super(mod, beClass, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60924_((state, world, pos) -> false).m_60966_().m_60918_(SoundType.f_56740_));
        this.nonFloatingBlock = nonFloatingBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(SetupContext ctx) {
        ctx.enqueue(() -> BlockEntityRenderers.m_173590_((BlockEntityType)this.getBlockEntityType(), mgr -> new RenderFunctionalFlower()));
    }

    public BlockFunctionalFlower<T> getNonFloatingBlock() {
        return this.nonFloatingBlock;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        FunctionalFlowerBase te = (FunctionalFlowerBase)this.getBlockEntity(level, pos);
        if (te.getCurrentMana() > 0) {
            return 1 + (int)((double)te.getCurrentMana() / (double)te.maxMana * 14.0);
        }
        return 0;
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (this.getNonFloatingBlock().isGenerating) {
            tooltip.add((Component)Component.m_237115_((String)"botania.flowerType.generating").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"botania.flowerType.functional").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey(this.getNonFloatingBlock());
        if (id != null) {
            tooltip.add((Component)Component.m_237115_((String)("block." + id.m_135827_() + "." + id.m_135815_() + ".description")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return BotaniaConfig.client().staticFloaters() ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

