/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mythicbotany.config.MythicConfig;
import mythicbotany.register.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem;

public class CommonAlfsteelArmor {
    private static final List<UUID> ARMOR_ATTRIBUTE_SLOT_UIDS = List.of(UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));

    public static Multimap<Attribute, AttributeModifier> applyModifiers(TerrasteelArmorItem item, Multimap<Attribute, AttributeModifier> map, @Nullable EquipmentSlot slot) {
        LinkedHashMultimap ret = LinkedHashMultimap.create(map);
        ret.removeAll((Object)Attributes.f_22284_);
        ret.removeAll((Object)Attributes.f_22285_);
        ret.removeAll((Object)Attributes.f_22278_);
        if (slot == item.m_40402_()) {
            ret.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_ATTRIBUTE_SLOT_UIDS.get(slot.m_20749_()), "Armor modifier", (double)item.m_40404_(), AttributeModifier.Operation.ADDITION));
            ret.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_ATTRIBUTE_SLOT_UIDS.get(slot.m_20749_()), "Armor toughness", (double)item.m_40405_(), AttributeModifier.Operation.ADDITION));
            UUID uuid = new UUID(ForgeRegistries.ITEMS.getKey((Object)item).hashCode() + slot.toString().hashCode(), 0L);
            if (item == ModItems.alfsteelHelmet) {
                Attribute reachDistance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("forge", "reach_distance"));
                if (reachDistance != null) {
                    ret.put((Object)reachDistance, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + item.type, MythicConfig.alftools.reach_modifier, AttributeModifier.Operation.ADDITION));
                }
            } else if (item == ModItems.alfsteelChestplate) {
                ret.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + item.type, MythicConfig.alftools.knockback_resistance_modifier, AttributeModifier.Operation.ADDITION));
            } else if (item == ModItems.alfsteelLeggings) {
                ret.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + item.type, MythicConfig.alftools.speed_modifier, AttributeModifier.Operation.ADDITION));
                Attribute swimSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("forge", "swim_speed"));
                if (swimSpeed != null) {
                    UUID uuid2 = new UUID(ForgeRegistries.ITEMS.getKey((Object)item).hashCode() + slot.toString().hashCode(), 1L);
                    ret.put((Object)swimSpeed, (Object)new AttributeModifier(uuid2, "Alfsteel modifier swim " + item.type, MythicConfig.alftools.speed_modifier, AttributeModifier.Operation.ADDITION));
                }
            }
        }
        return ret;
    }

    public static void addArmorSetDescription(ItemStack stack, List<Component> list) {
        if (stack.m_41720_() == ModItems.alfsteelHelmet) {
            list.add((Component)Component.m_237115_((String)"item.mythicbotany.alfsteel_helmet.description").m_130940_(ChatFormatting.GOLD));
        } else if (stack.m_41720_() == ModItems.alfsteelChestplate) {
            list.add((Component)Component.m_237115_((String)"item.mythicbotany.alfsteel_chestplate.description").m_130940_(ChatFormatting.GOLD));
        } else if (stack.m_41720_() == ModItems.alfsteelLeggings) {
            list.add((Component)Component.m_237115_((String)"item.mythicbotany.alfsteel_leggings.description").m_130940_(ChatFormatting.GOLD));
        } else if (stack.m_41720_() == ModItems.alfsteelBoots) {
            list.add((Component)Component.m_237115_((String)"item.mythicbotany.alfsteel_boots.description").m_130940_(ChatFormatting.GOLD));
        }
    }

    public static boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> {
                if (stack.m_41720_() == ModItems.alfsteelHelmet) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.CHEST -> {
                if (stack.m_41720_() == ModItems.alfsteelChestplate) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.LEGS -> {
                if (stack.m_41720_() == ModItems.alfsteelLeggings) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.FEET -> {
                if (stack.m_41720_() == ModItems.alfsteelBoots) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static int getDefense(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> MythicConfig.alftools.armor_values.helmet.defense();
            case EquipmentSlot.CHEST -> MythicConfig.alftools.armor_values.chestplate.defense();
            case EquipmentSlot.LEGS -> MythicConfig.alftools.armor_values.leggings.defense();
            case EquipmentSlot.FEET -> MythicConfig.alftools.armor_values.boots.defense();
            default -> 0;
        };
    }

    public static float getToughness(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> MythicConfig.alftools.armor_values.helmet.toughness();
            case EquipmentSlot.CHEST -> MythicConfig.alftools.armor_values.chestplate.toughness();
            case EquipmentSlot.LEGS -> MythicConfig.alftools.armor_values.leggings.toughness();
            case EquipmentSlot.FEET -> MythicConfig.alftools.armor_values.boots.toughness();
            default -> 0.0f;
        };
    }
}

