/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.teleporter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mythicbotany.MythicBotany;
import mythicbotany.alfheim.Alfheim;
import mythicbotany.config.MythicConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import org.moddingx.libx.render.RenderHelper;
import vazkii.botania.client.core.handler.MiscellaneousModels;

public class AlfheimPortalHandler {
    public static int clientInPortalTime;
    private static final Set<ServerPlayer> inPortal;
    private static final Set<ServerPlayer> portalBlocked;
    private static final Map<ServerPlayer, Integer> timesInPortal;

    public static void serverStarted(ServerStartedEvent event) {
        inPortal.clear();
        portalBlocked.clear();
        timesInPortal.clear();
    }

    public static void endTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerPlayer player;
            Iterator<ServerPlayer> itr = timesInPortal.keySet().iterator();
            while (itr.hasNext()) {
                player = itr.next();
                if (inPortal.contains(player)) continue;
                MythicBotany.getNetwork().updatePortalTime(player, 0);
                itr.remove();
            }
            itr = portalBlocked.iterator();
            while (itr.hasNext()) {
                player = itr.next();
                if (!AlfheimPortalHandler.canRemovePortalBlocked(player)) continue;
                MythicBotany.getNetwork().updatePortalTime(player, 0);
                itr.remove();
            }
            portalBlocked.removeIf(AlfheimPortalHandler::canRemovePortalBlocked);
            inPortal.clear();
        }
    }

    private static boolean canRemovePortalBlocked(ServerPlayer player) {
        if (player.m_20092_()) {
            return false;
        }
        if (inPortal.contains(player)) {
            return false;
        }
        BlockPos pos = player.m_20183_();
        return player.f_19853_.m_151570_(pos) || player.f_19853_.m_46749_(pos);
    }

    public static boolean setInPortal(Level level, Player playerEntity) {
        if (!level.f_46443_ && (MythicConfig.enableAlfheim || Objects.equals(level.m_46472_(), Alfheim.DIMENSION)) && playerEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerEntity;
            inPortal.add(player);
            if (!portalBlocked.contains(player) && !playerEntity.m_20092_()) {
                int timeInPortal;
                if (!timesInPortal.containsKey(player)) {
                    timesInPortal.put(player, 1);
                    timeInPortal = 1;
                } else {
                    timeInPortal = timesInPortal.get(player) + 1;
                    timesInPortal.put(player, timeInPortal);
                }
                MythicBotany.getNetwork().updatePortalTime(player, timeInPortal);
                if (timeInPortal >= 120) {
                    portalBlocked.add(player);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean shouldCheck(Level level) {
        if (!MythicConfig.enableAlfheim && !Objects.equals(level.m_46472_(), Alfheim.DIMENSION)) {
            return false;
        }
        if (level instanceof ServerLevel) {
            return !timesInPortal.isEmpty() || !portalBlocked.isEmpty() || ((ServerLevel)level).m_7654_().m_129921_() % 4 == 3;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGameOverlay(RenderGuiEvent.Post event) {
        if (clientInPortalTime > 0 && !(Minecraft.m_91087_().f_91080_ instanceof PauseScreen)) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            int w = Minecraft.m_91087_().m_91268_().m_85445_();
            int h = Minecraft.m_91087_().m_91268_().m_85446_();
            float scale = (float)Math.max(w, h) / 48.0f;
            poseStack.m_85837_(w < h ? (double)((h - w) / -2) : 0.0, w > h ? (double)((w - h) / -2) : 0.0, 0.0);
            poseStack.m_85841_(scale, scale, scale);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.m_14036_((float)(((float)clientInPortalTime + Minecraft.m_91087_().m_91296_()) / 120.0f), (float)0.05f, (float)0.8f));
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscellaneousModels.INSTANCE.alfPortalTex.m_119193_());
            GuiComponent.m_93200_((PoseStack)poseStack, (int)0, (int)0, (int)0, (int)48, (int)48, (TextureAtlasSprite)MiscellaneousModels.INSTANCE.alfPortalTex.m_119204_());
            RenderHelper.resetColor();
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
    }

    static {
        inPortal = new HashSet<ServerPlayer>();
        portalBlocked = new HashSet<ServerPlayer>();
        timesInPortal = new HashMap<ServerPlayer, Integer>();
    }
}

