/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import mythicbotany.alfheim.datagen.AlfheimProvider;
import mythicbotany.alfheim.worldgen.feature.AbandonedApothecaryConfiguration;
import mythicbotany.alfheim.worldgen.tree.RandomFoliagePlacer;
import mythicbotany.alfheim.worldgen.tree.ShatteredTrunkPlacer;
import mythicbotany.config.MythicConfig;
import mythicbotany.data.AdvancementProvider;
import mythicbotany.data.BlockStateProvider;
import mythicbotany.data.CommonTagsProvider;
import mythicbotany.data.ItemModelProvider;
import mythicbotany.data.lexicon.LexiconProvider;
import mythicbotany.data.loot.BlockLootProvider;
import mythicbotany.data.loot.EntityLootProvider;
import mythicbotany.data.recipes.RecipeProvider;
import mythicbotany.mjoellnir.RenderMjoellnir;
import mythicbotany.register.ModBlocks;
import mythicbotany.register.ModEnchantments;
import mythicbotany.register.ModEntities;
import mythicbotany.register.ModFeatures;
import mythicbotany.register.ModItems;
import mythicbotany.register.ModRecipes;
import net.minecraft.core.Registry;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.DistExecutor;
import org.moddingx.libx.annotation.impl.LazyMapBuilder;
import org.moddingx.libx.annotation.impl.ProcessorInterface;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.mod.ModXRegistration;

public class MythicBotany$ {
    private static ModX mod = null;
    public static final Map<Class<?>, Codec<?>> codecs = MythicBotany$.buildCodecs();

    private static final Map<Class<?>, Codec<?>> buildCodecs() {
        LazyMapBuilder builder = ProcessorInterface.lazyMapBuilder();
        builder.put(ShatteredTrunkPlacer.class, () -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("base_height").forGetter(ShatteredTrunkPlacer::getBaseHeight), (App)Codec.INT.fieldOf("height_rand_a").forGetter(ShatteredTrunkPlacer::getHeightRandA), (App)Codec.INT.fieldOf("height_rand_b").forGetter(ShatteredTrunkPlacer::getHeightRandB)).apply((Applicative)instance, instance.stable((ctorArg0, ctorArg1, ctorArg2) -> new ShatteredTrunkPlacer((int)ctorArg0, (int)ctorArg1, (int)ctorArg2)))));
        builder.put(RandomFoliagePlacer.class, () -> RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("radius").forGetter(RandomFoliagePlacer::getRadius), (App)IntProvider.f_146531_.fieldOf("offset").forGetter(RandomFoliagePlacer::getOffset)).apply((Applicative)instance, instance.stable((ctorArg0, ctorArg1) -> new RandomFoliagePlacer((IntProvider)ctorArg0, (IntProvider)ctorArg1)))));
        builder.put(AbandonedApothecaryConfiguration.class, () -> RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.listOf().fieldOf("states").forGetter(AbandonedApothecaryConfiguration::states), (App)AbandonedApothecaryConfiguration.fieldOf("petals").forGetter(AbandonedApothecaryConfiguration::petals)).apply((Applicative)instance, instance.stable((ctorArg0, ctorArg1) -> new AbandonedApothecaryConfiguration((List<BlockState>)ctorArg0, (List<Item>)ctorArg1)))));
        return builder.build();
    }

    public static void init(ModX mod) {
        MythicBotany$.mod = mod;
        ProcessorInterface.registerConfig((ModX)mod, (String)"config", MythicConfig.class, (boolean)false);
        ((ModXRegistration)mod).addRegistrationHandler(MythicBotany$::register);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ProcessorInterface.addModListener(ModelEvent.RegisterAdditional.class, MythicBotany$::registerModels);
            ProcessorInterface.addLowModListener(ModelEvent.BakingCompleted.class, MythicBotany$::bakeModels);
        });
        ProcessorInterface.addModListener(GatherDataEvent.class, MythicBotany$::gatherData);
    }

    private static void register() {
        ProcessorInterface.runUnchecked(() -> {
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122849_, (String)"shattered_trunk", ShatteredTrunkPlacer.TYPE, () -> ShatteredTrunkPlacer.class.getDeclaredField("TYPE"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122848_, (String)"random_foliage", RandomFoliagePlacer.TYPE, () -> RandomFoliagePlacer.class.getDeclaredField("TYPE"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"mana_infuser", ModBlocks.manaInfuser, () -> ModBlocks.class.getDeclaredField("manaInfuser"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"alfsteel_block", (Object)ModBlocks.alfsteelBlock, () -> ModBlocks.class.getDeclaredField("alfsteelBlock"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"alfsteel_pylon", ModBlocks.alfsteelPylon, () -> ModBlocks.class.getDeclaredField("alfsteelPylon"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"mana_collector", ModBlocks.manaCollector, () -> ModBlocks.class.getDeclaredField("manaCollector"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"exoblaze", ModBlocks.exoblaze, () -> ModBlocks.class.getDeclaredField("exoblaze"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"wither_aconite", ModBlocks.witherAconite, () -> ModBlocks.class.getDeclaredField("witherAconite"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"aquapanthus", ModBlocks.aquapanthus, () -> ModBlocks.class.getDeclaredField("aquapanthus"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"hellebore", ModBlocks.hellebore, () -> ModBlocks.class.getDeclaredField("hellebore"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"raindeletia", ModBlocks.raindeletia, () -> ModBlocks.class.getDeclaredField("raindeletia"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"feysythia", ModBlocks.feysythia, () -> ModBlocks.class.getDeclaredField("feysythia"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"petrunia", ModBlocks.petrunia, () -> ModBlocks.class.getDeclaredField("petrunia"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"yggdrasil_branch", ModBlocks.yggdrasilBranch, () -> ModBlocks.class.getDeclaredField("yggdrasilBranch"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"rune_holder", ModBlocks.runeHolder, () -> ModBlocks.class.getDeclaredField("runeHolder"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"central_rune_holder", ModBlocks.centralRuneHolder, () -> ModBlocks.class.getDeclaredField("centralRuneHolder"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"mjoellnir", (Object)((Object)ModBlocks.mjoellnir), () -> ModBlocks.class.getDeclaredField("mjoellnir"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"dreamwood_leaves", (Object)ModBlocks.dreamwoodLeaves, () -> ModBlocks.class.getDeclaredField("dreamwoodLeaves"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"elementium_ore", (Object)ModBlocks.elementiumOre, () -> ModBlocks.class.getDeclaredField("elementiumOre"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"dragonstone_ore", (Object)ModBlocks.dragonstoneOre, () -> ModBlocks.class.getDeclaredField("dragonstoneOre"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"gold_ore", (Object)ModBlocks.goldOre, () -> ModBlocks.class.getDeclaredField("goldOre"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"raw_elementium_block", (Object)ModBlocks.rawElementiumBlock, () -> ModBlocks.class.getDeclaredField("rawElementiumBlock"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122901_, (String)"return_portal", ModBlocks.returnPortal, () -> ModBlocks.class.getDeclaredField("returnPortal"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122903_, (String)"alf_pixie", ModEntities.alfPixie, () -> ModEntities.class.getDeclaredField("alfPixie"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122838_, (String)"abandoned_apothecaries", ModFeatures.abandonedApothecaries, () -> ModFeatures.class.getDeclaredField("abandonedApothecaries"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122838_, (String)"mana_crystals", ModFeatures.manaCrystals, () -> ModFeatures.class.getDeclaredField("manaCrystals"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122838_, (String)"motif_flowers", ModFeatures.motifFlowers, () -> ModFeatures.class.getDeclaredField("motifFlowers"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122838_, (String)"wheat_fields", ModFeatures.wheatFields, () -> ModFeatures.class.getDeclaredField("wheatFields"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122902_, (String)"hammer_mobility", (Object)ModEnchantments.hammerMobility, () -> ModEnchantments.class.getDeclaredField("hammerMobility"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122914_, (String)"infuser", ModRecipes.infuser, () -> ModRecipes.class.getDeclaredField("infuser"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122914_, (String)"rune_ritual", ModRecipes.runeRitual, () -> ModRecipes.class.getDeclaredField("runeRitual"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"asgard_rune", (Object)ModItems.asgardRune, () -> ModItems.class.getDeclaredField("asgardRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"vanaheim_rune", (Object)ModItems.vanaheimRune, () -> ModItems.class.getDeclaredField("vanaheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfheim_rune", (Object)ModItems.alfheimRune, () -> ModItems.class.getDeclaredField("alfheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"midgard_rune", (Object)ModItems.midgardRune, () -> ModItems.class.getDeclaredField("midgardRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"joetunheim_rune", (Object)ModItems.joetunheimRune, () -> ModItems.class.getDeclaredField("joetunheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"muspelheim_rune", (Object)ModItems.muspelheimRune, () -> ModItems.class.getDeclaredField("muspelheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"niflheim_rune", (Object)ModItems.niflheimRune, () -> ModItems.class.getDeclaredField("niflheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"nidavellir_rune", (Object)ModItems.nidavellirRune, () -> ModItems.class.getDeclaredField("nidavellirRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"helheim_rune", (Object)ModItems.helheimRune, () -> ModItems.class.getDeclaredField("helheimRune"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_ingot", (Object)ModItems.alfsteelIngot, () -> ModItems.class.getDeclaredField("alfsteelIngot"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_nugget", (Object)ModItems.alfsteelNugget, () -> ModItems.class.getDeclaredField("alfsteelNugget"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_sword", (Object)ModItems.alfsteelSword, () -> ModItems.class.getDeclaredField("alfsteelSword"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_pick", (Object)ModItems.alfsteelPick, () -> ModItems.class.getDeclaredField("alfsteelPick"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_axe", (Object)ModItems.alfsteelAxe, () -> ModItems.class.getDeclaredField("alfsteelAxe"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_helmet", (Object)ModItems.alfsteelHelmet, () -> ModItems.class.getDeclaredField("alfsteelHelmet"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_chestplate", (Object)ModItems.alfsteelChestplate, () -> ModItems.class.getDeclaredField("alfsteelChestplate"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_leggings", (Object)ModItems.alfsteelLeggings, () -> ModItems.class.getDeclaredField("alfsteelLeggings"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alfsteel_boots", (Object)ModItems.alfsteelBoots, () -> ModItems.class.getDeclaredField("alfsteelBoots"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"mana_ring_greatest", (Object)ModItems.manaRingGreatest, () -> ModItems.class.getDeclaredField("manaRingGreatest"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"aura_ring_greatest", (Object)ModItems.auraRingGreatest, () -> ModItems.class.getDeclaredField("auraRingGreatest"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"faded_nether_star", (Object)ModItems.fadedNetherStar, () -> ModItems.class.getDeclaredField("fadedNetherStar"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"fire_ring", (Object)ModItems.fireRing, () -> ModItems.class.getDeclaredField("fireRing"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"ice_ring", (Object)ModItems.iceRing, () -> ModItems.class.getDeclaredField("iceRing"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"gjallar_horn_empty", (Object)ModItems.gjallarHornEmpty, () -> ModItems.class.getDeclaredField("gjallarHornEmpty"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"gjallar_horn_full", (Object)ModItems.gjallarHornFull, () -> ModItems.class.getDeclaredField("gjallarHornFull"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"cursed_andwari_ring", (Object)ModItems.cursedAndwariRing, () -> ModItems.class.getDeclaredField("cursedAndwariRing"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"andwari_ring", (Object)ModItems.andwariRing, () -> ModItems.class.getDeclaredField("andwariRing"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"fimbultyr_tablet", (Object)ModItems.fimbultyrTablet, () -> ModItems.class.getDeclaredField("fimbultyrTablet"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"kvasir_blood", (Object)ModItems.kvasirBlood, () -> ModItems.class.getDeclaredField("kvasirBlood"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"kvasir_mead", (Object)ModItems.kvasirMead, () -> ModItems.class.getDeclaredField("kvasirMead"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"dream_cherry", (Object)ModItems.dreamCherry, () -> ModItems.class.getDeclaredField("dreamCherry"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"raw_elementium", (Object)ModItems.rawElementium, () -> ModItems.class.getDeclaredField("rawElementium"), (boolean)false);
            ProcessorInterface.register((ModX)mod, (ResourceKey)Registry.f_122904_, (String)"alf_pixie_spawn_egg", (Object)ModItems.alfPixieSpawnEgg, () -> ModItems.class.getDeclaredField("alfPixieSpawnEgg"), (boolean)false);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerModels(ModelEvent.RegisterAdditional event) {
        ProcessorInterface.addSpecialModel((ModelEvent.RegisterAdditional)event, (ResourceLocation)ProcessorInterface.newRL((String)"mythicbotany", (String)"block/mjoellnir"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void bakeModels(ModelEvent.BakingCompleted event) {
        RenderMjoellnir.model = ProcessorInterface.getSpecialModel((ModelEvent.BakingCompleted)event, (ResourceLocation)ProcessorInterface.newRL((String)"mythicbotany", (String)"block/mjoellnir"));
    }

    private static void gatherData(GatherDataEvent event) {
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new BlockLootProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new EntityLootProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new CommonTagsProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event), ProcessorInterface.getDataFileHelper((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new BlockStateProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event), ProcessorInterface.getDataFileHelper((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new RecipeProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new LexiconProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event), ProcessorInterface.getDataFileHelper((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new AdvancementProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new ItemModelProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event), ProcessorInterface.getDataFileHelper((GatherDataEvent)event)));
        ProcessorInterface.addDataProvider((GatherDataEvent)event, (DataProvider)new AlfheimProvider(mod, ProcessorInterface.getDataGenerator((GatherDataEvent)event), ProcessorInterface.getDataFileHelper((GatherDataEvent)event)));
    }
}

