/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;

@NothingNullByDefault
public class RenderWindGenerator
extends ModelTileEntityRenderer<TileEntityWindGenerator, ModelWindGenerator>
implements IWireFrameRenderer {
    public RenderWindGenerator(BlockEntityRendererProvider.Context context) {
        super(context, ModelWindGenerator::new);
    }

    protected void render(TileEntityWindGenerator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        this.renderTranslated(tile, partialTick, matrix, (poseStack, angle) -> ((ModelWindGenerator)this.model).render(poseStack, renderer, angle, light, overlayLight, false));
    }

    protected String getProfilerSection() {
        return "windGenerator";
    }

    public boolean shouldRenderOffScreen(TileEntityWindGenerator tile) {
        return true;
    }

    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer, int red, int green, int blue, int alpha) {
        if (tile instanceof TileEntityWindGenerator) {
            TileEntityWindGenerator windGenerator = (TileEntityWindGenerator)tile;
            this.renderTranslated(windGenerator, partialTick, matrix, (poseStack, angle) -> ((ModelWindGenerator)this.model).renderWireFrame(poseStack, buffer, angle, red, green, blue, alpha));
        }
    }

    private void renderTranslated(TileEntityWindGenerator tile, float partialTick, PoseStack matrix, WindGeneratorRenderer renderer) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate((PoseStack)matrix, (Direction)tile.getDirection(), (float)0.0f, (float)180.0f, (float)90.0f, (float)270.0f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        double angle = tile.getAngle();
        if (tile.getActive()) {
            angle = (tile.getAngle() + (double)(((float)tile.m_58899_().m_123342_() + 4.0f) / 8.0f * partialTick)) % 360.0;
        }
        renderer.render(matrix, angle);
        matrix.m_85849_();
    }

    private static interface WindGeneratorRenderer {
        public void render(PoseStack var1, double var2);
    }
}

