/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.RobitPrideSkinData;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketRobit
implements IMekanismPacket {
    private static final Map<String, List<IRobitSkinProvider>> EASTER_EGGS = Map.of("sara", PacketRobit.getPrideSkins(RobitPrideSkinData.TRANS, RobitPrideSkinData.LESBIAN));
    private final RobitPacketType activeType;
    private final int entityId;
    private final String name;
    private final RobitSkin skin;

    private static List<IRobitSkinProvider> getPrideSkins(RobitPrideSkinData ... prideSkinData) {
        return Stream.of(prideSkinData).map(MekanismRobitSkins.PRIDE_SKINS::get).toList();
    }

    public PacketRobit(RobitPacketType type, EntityRobit robit) {
        this(type, robit.m_19879_(), null, null);
    }

    public PacketRobit(EntityRobit robit, @NotNull String name) {
        this(RobitPacketType.NAME, robit, name, null);
    }

    public PacketRobit(EntityRobit robit, @NotNull RobitSkin skin) {
        this(RobitPacketType.SKIN, robit, null, skin);
    }

    private PacketRobit(RobitPacketType type, EntityRobit robit, @Nullable String name, @Nullable RobitSkin skin) {
        this(type, robit.m_19879_(), name, skin);
    }

    private PacketRobit(RobitPacketType type, int entityId, @Nullable String name, @Nullable RobitSkin skin) {
        this.activeType = type;
        this.entityId = entityId;
        this.name = name;
        this.skin = skin;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        EntityRobit robit;
        ServerPlayer player = context.getSender();
        if (player != null && (robit = (EntityRobit)player.f_19853_.m_6815_(this.entityId)) != null && MekanismAPI.getSecurityUtils().canAccess((Player)player, (ICapabilityProvider)robit)) {
            if (this.activeType == RobitPacketType.GO_HOME) {
                robit.goHome();
            } else if (this.activeType == RobitPacketType.FOLLOW) {
                robit.setFollowing(!robit.getFollowing());
            } else if (this.activeType == RobitPacketType.DROP_PICKUP) {
                robit.setDropPickup(!robit.getDropPickup());
            } else if (this.activeType == RobitPacketType.NAME) {
                List skins;
                robit.m_6593_((Component)TextComponentUtil.getString(this.name));
                if (robit.getSkin() == MekanismRobitSkins.BASE.get() && !(skins = EASTER_EGGS.getOrDefault(this.name.toLowerCase(Locale.ROOT), Collections.emptyList())).isEmpty()) {
                    robit.setSkin((IRobitSkinProvider)skins.get(robit.f_19853_.f_46441_.m_188503_(skins.size())), null);
                }
            } else if (this.activeType == RobitPacketType.SKIN) {
                robit.setSkin(this.skin, (Player)player);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.activeType);
        buffer.m_130130_(this.entityId);
        if (this.activeType == RobitPacketType.NAME) {
            buffer.m_130070_(this.name);
        } else if (this.activeType == RobitPacketType.SKIN) {
            buffer.writeRegistryId(MekanismAPI.robitSkinRegistry(), (Object)this.skin);
        }
    }

    public static PacketRobit decode(FriendlyByteBuf buffer) {
        RobitPacketType activeType = (RobitPacketType)buffer.m_130066_(RobitPacketType.class);
        int entityId = buffer.m_130242_();
        String name = null;
        RobitSkin skin = null;
        if (activeType == RobitPacketType.NAME) {
            name = BasePacketHandler.readString(buffer).trim();
        } else if (activeType == RobitPacketType.SKIN) {
            skin = (RobitSkin)buffer.readRegistryIdSafe(RobitSkin.class);
        }
        return new PacketRobit(activeType, entityId, name, skin);
    }

    public static enum RobitPacketType {
        GO_HOME,
        FOLLOW,
        DROP_PICKUP,
        NAME,
        SKIN;

    }
}

