/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiEnergyTab
extends GuiTexturedElement {
    private static final Map<UnitDisplayUtils.EnergyUnit, ResourceLocation> ICONS = new EnumMap<UnitDisplayUtils.EnergyUnit, ResourceLocation>(UnitDisplayUtils.EnergyUnit.class);
    private final GuiTexturedElement.IInfoHandler infoHandler;

    public GuiEnergyTab(IGuiWrapper gui, GuiTexturedElement.IInfoHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info.png"), gui, -26, 137, 26, 26);
        this.infoHandler = handler;
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, FloatingLongSupplier lastEnergyUsed) {
        this(gui, () -> List.of(MekanismLang.USING.translate(EnergyDisplay.of(lastEnergyUsed.get())), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded()))));
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, BooleanSupplier isActive) {
        this(gui, () -> {
            FloatingLong using = isActive.getAsBoolean() ? energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
            return List.of(MekanismLang.USING.translate(EnergyDisplay.of(using)), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded())));
        });
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiEnergyTab.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_93618_, (int)this.f_93619_);
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        ArrayList<Component> info = new ArrayList<Component>(this.infoHandler.getInfo());
        info.add((Component)MekanismLang.UNIT.translate(UnitDisplayUtils.EnergyUnit.getConfigured()));
        this.displayTooltips(matrix, mouseX, mouseY, info);
    }

    @Override
    protected ResourceLocation getResource() {
        return ICONS.computeIfAbsent(UnitDisplayUtils.EnergyUnit.getConfigured(), type -> MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info_" + type.getTabName() + ".png"));
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.updateEnergyUnit(IIncrementalEnum::getNext);
        } else if (button == 1) {
            this.updateEnergyUnit(IIncrementalEnum::getPrevious);
        }
    }

    public boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    private void updateEnergyUnit(UnaryOperator<UnitDisplayUtils.EnergyUnit> converter) {
        UnitDisplayUtils.EnergyUnit updated;
        UnitDisplayUtils.EnergyUnit current = UnitDisplayUtils.EnergyUnit.getConfigured();
        if (current != (updated = (UnitDisplayUtils.EnergyUnit)converter.apply(current))) {
            MekanismConfig.common.energyUnit.set(updated);
            MekanismConfig.common.save();
        }
    }
}

