/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.command;

import com.google.gson.JsonObject;
import com.kotori316.limiter.SpawnConditionLoader;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.command.ConditionParser;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.VisibleForTesting;

class TestSpawnParser {
    static final SimpleCommandExceptionType TYPE_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Type not found."));
    static final SimpleCommandExceptionType PROPERTY_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Property not found."));
    static final DynamicCommandExceptionType FAILED_CREATE_INSTANCE = new DynamicCommandExceptionType(o -> Component.m_237113_((String)("Error " + o)));
    private final StringReader reader;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestion = SuggestionsBuilder::buildFuture;
    private String ruleName;
    private final JsonObject object = new JsonObject();

    TestSpawnParser(StringReader reader) {
        this.reader = reader;
    }

    static String getRuleName(StringReader reader, int first, int endExclusive) throws CommandSyntaxException {
        String name = reader.getString().substring(first, endExclusive);
        if (SpawnConditionLoader.INSTANCE.hasSerializeKey(name)) {
            return name;
        }
        reader.setCursor(first);
        throw TYPE_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    static CompletableFuture<Suggestions> suggestRuleName(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(SpawnConditionLoader.INSTANCE.serializeKeySet(), (SuggestionsBuilder)builder);
    }

    static CompletableFuture<Suggestions> suggestStartProperties(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('['));
        }
        return builder.buildFuture();
    }

    static Set<String> getPropertyKeysRest(String ruleName, JsonObject object) {
        return SpawnConditionLoader.INSTANCE.getSerializer(ruleName).propertyKeys().stream().filter(aKey -> !GsonHelper.m_13900_((JsonObject)object, (String)aKey)).map(s -> s + "=").collect(Collectors.toSet());
    }

    static Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestPropertyKeys(String ruleName, JsonObject object) {
        return builder -> SharedSuggestionProvider.m_82970_(TestSpawnParser.getPropertyKeysRest(ruleName, object), (SuggestionsBuilder)builder);
    }

    static CompletableFuture<Suggestions> suggestComma(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(','));
        }
        return builder.buildFuture();
    }

    static CompletableFuture<Suggestions> suggestEndProperties(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return builder.buildFuture();
    }

    void parse() throws CommandSyntaxException {
        this.parseWithProvider(null);
    }

    void parseWithProvider(@Nullable SharedSuggestionProvider provider) throws CommandSyntaxException {
        this.suggestion = TestSpawnParser::suggestRuleName;
        int i = this.reader.getCursor();
        while (this.reader.canRead() && this.reader.peek() != '[') {
            this.reader.skip();
        }
        this.ruleName = TestSpawnParser.getRuleName(this.reader, i, this.reader.getCursor());
        this.reader.skipWhitespace();
        this.suggestion = TestSpawnParser::suggestStartProperties;
        if (!this.reader.canRead()) {
            throw PROPERTY_NOT_FOUND.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
        this.suggestion = TestSpawnParser.suggestPropertyKeys(this.ruleName, this.object);
        ConditionParser parser = ConditionParser.findParser(this.ruleName);
        parser.parse(this.ruleName, this.reader, this.object, this::setSuggestion, provider);
    }

    private void setSuggestion(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestion) {
        this.suggestion = suggestion;
    }

    TestSpawn createInstance() throws CommandSyntaxException {
        this.object.addProperty("type", this.ruleName);
        try {
            return SpawnConditionLoader.INSTANCE.deserialize(this.object);
        }
        catch (RuntimeException e) {
            throw FAILED_CREATE_INSTANCE.createWithContext((ImmutableStringReader)this.reader, (Object)e);
        }
    }

    CompletableFuture<Suggestions> getSuggestion(SuggestionsBuilder builder) {
        return this.suggestion.apply(builder.createOffset(this.reader.getCursor()));
    }

    @VisibleForTesting
    String foundRuleName() {
        return this.ruleName;
    }
}

