/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.command;

import com.google.gson.JsonObject;
import com.kotori316.limiter.SpawnConditionLoader;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.command.ConditionParser;
import com.kotori316.limiter.command.TestSpawnParser;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;

class ParseOneCondition
implements ConditionParser {
    ParseOneCondition() {
    }

    @Override
    public void parse(String typeName, StringReader reader, JsonObject context, Consumer<Function<SuggestionsBuilder, CompletableFuture<Suggestions>>> suggestionSetter, @Nullable SharedSuggestionProvider provider) throws CommandSyntaxException {
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            int pairStart = reader.getCursor();
            while (reader.canRead() && reader.peek() != ',' && reader.peek() != ']') {
                reader.skip();
            }
            this.readRuleProperties(typeName, reader, pairStart, reader.getCursor(), context, suggestionSetter, provider);
            if (!reader.canRead()) continue;
            if (reader.peek() == ',') {
                reader.skip();
                suggestionSetter.accept(TestSpawnParser.suggestPropertyKeys(typeName, context));
                continue;
            }
            suggestionSetter.accept(SuggestionsBuilder::buildFuture);
        }
        if (!reader.canRead() || reader.peek() != ']') {
            if (SpawnConditionLoader.INSTANCE.getSerializer(typeName).propertyKeys().isEmpty()) {
                suggestionSetter.accept(TestSpawnParser::suggestEndProperties);
            }
            throw TestSpawnParser.FAILED_CREATE_INSTANCE.createWithContext((ImmutableStringReader)reader, (Object)"Not finished statement.");
        }
        reader.skip();
    }

    void readRuleProperties(String ruleName, StringReader reader, int first, int endExclusive, JsonObject object, Consumer<Function<SuggestionsBuilder, CompletableFuture<Suggestions>>> suggestionSetter, @Nullable SharedSuggestionProvider provider) throws CommandSyntaxException {
        String pair = reader.getString().substring(first, endExclusive);
        if (!pair.contains("=")) {
            reader.setCursor(first);
            throw TestSpawnParser.FAILED_CREATE_INSTANCE.createWithContext((ImmutableStringReader)reader, (Object)"= expected after key");
        }
        suggestionSetter.accept(this.generateSuggestPropertyValues(ruleName, pair.substring(0, pair.indexOf("=")), provider));
        try {
            String[] split = pair.split("=", 2);
            try {
                object.addProperty(split[0], (Number)Integer.parseInt(split[1]));
            }
            catch (NumberFormatException ignore) {
                Set<String> possibleValues = SpawnConditionLoader.INSTANCE.getSerializer(ruleName).possibleValues(split[0], false, provider);
                if (possibleValues.isEmpty() || possibleValues.contains(split[1])) {
                    object.addProperty(split[0], split[1]);
                }
                reader.setCursor(first + pair.indexOf("=") + 1);
                throw TestSpawnParser.FAILED_CREATE_INSTANCE.createWithContext((ImmutableStringReader)reader, (Object)"invalid value");
            }
            if (TestSpawnParser.getPropertyKeysRest(ruleName, object).isEmpty()) {
                suggestionSetter.accept(TestSpawnParser::suggestEndProperties);
            } else if (split[1].isEmpty()) {
                suggestionSetter.accept(SuggestionsBuilder::buildFuture);
            } else {
                suggestionSetter.accept(TestSpawnParser::suggestComma);
            }
        }
        catch (RuntimeException e) {
            reader.setCursor(first);
            throw TestSpawnParser.FAILED_CREATE_INSTANCE.createWithContext((ImmutableStringReader)reader, (Object)e);
        }
    }

    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> generateSuggestPropertyValues(String ruleName, String key, SharedSuggestionProvider provider) {
        TestSpawn.Serializer<?> serializer = SpawnConditionLoader.INSTANCE.getSerializer(ruleName);
        Set<ResourceLocation> locationSuggestion = serializer.suggestions(key, provider);
        if (!locationSuggestion.isEmpty()) {
            return builder -> SharedSuggestionProvider.m_82926_((Iterable)locationSuggestion, (SuggestionsBuilder)builder);
        }
        return builder -> SharedSuggestionProvider.m_82970_(serializer.possibleValues(key, true, provider), (SuggestionsBuilder)builder);
    }
}

