/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.command;

import com.google.common.collect.Sets;
import com.kotori316.limiter.Config;
import com.kotori316.limiter.SpawnConditionLoader;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.capability.Caps;
import com.kotori316.limiter.capability.LMSConditionsHolder;
import com.kotori316.limiter.capability.LMSHandler;
import com.kotori316.limiter.capability.RuleType;
import com.kotori316.limiter.command.TestSpawnArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.command.EnumArgument;

public class LMSCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literal = Commands.m_82127_((String)"limitmobspawn");
        LiteralArgumentBuilder query = Commands.m_82127_((String)"query");
        LiteralArgumentBuilder world = Commands.m_82127_((String)"world");
        LMSCommand.registerQuery((LiteralArgumentBuilder<CommandSourceStack>)world, LMSCommand::getLmsHandler);
        query.then((ArgumentBuilder)world);
        LiteralArgumentBuilder dataPack = Commands.m_82127_((String)"datapack");
        LMSCommand.registerQuery((LiteralArgumentBuilder<CommandSourceStack>)dataPack, c -> SpawnConditionLoader.INSTANCE.getHolder());
        query.then((ArgumentBuilder)dataPack);
        literal.then(query.executes(context -> {
            LMSHandler lmsHandler = LMSCommand.getLmsHandler((CommandContext<CommandSourceStack>)context);
            if (lmsHandler.getDefaultConditions().isEmpty() && lmsHandler.getForceConditions().isEmpty() && lmsHandler.getDenyConditions().isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Rules found."));
            }
            LMSCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Defaults", (Set<TestSpawn>)Sets.union(lmsHandler.getDefaultConditions(), SpawnConditionLoader.INSTANCE.getHolder().getDefaultConditions()));
            LMSCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Denies", (Set<TestSpawn>)Sets.union(lmsHandler.getDenyConditions(), SpawnConditionLoader.INSTANCE.getHolder().getDenyConditions()));
            LMSCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Forces", (Set<TestSpawn>)Sets.union(lmsHandler.getForceConditions(), SpawnConditionLoader.INSTANCE.getHolder().getForceConditions()));
            return 1;
        }));
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(s -> s.m_6761_(Config.getInstance().getPermission()));
        for (RuleType ruleType : RuleType.values()) {
            add.then(Commands.m_82127_((String)ruleType.saveName()).then(Commands.m_82129_((String)"rule", (ArgumentType)new TestSpawnArgument()).executes(context -> {
                List<LMSHandler> list = LMSCommand.getAllLmsHandlers((CommandContext<CommandSourceStack>)context);
                TestSpawn rule = (TestSpawn)context.getArgument("rule", TestSpawn.class);
                list.forEach(lmsHandler -> ruleType.add((LMSHandler)lmsHandler, rule));
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Added %s to %s.", rule, ruleType.saveName())), true);
                return 1;
            })));
        }
        literal.then((ArgumentBuilder)add);
        LiteralArgumentBuilder remove = (LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(s -> s.m_6761_(Config.getInstance().getPermission()));
        for (RuleType ruleType : RuleType.values()) {
            remove.then(Commands.m_82127_((String)ruleType.saveName()).executes(context -> {
                LMSCommand.getAllLmsHandlers((CommandContext<CommandSourceStack>)context).forEach(ruleType::removeAll);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Cleared " + ruleType.getCommandName())), true);
                return 1;
            }));
        }
        literal.then((ArgumentBuilder)remove);
        LiteralArgumentBuilder spawner = Commands.m_82127_((String)"spawner");
        spawner.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnCount").requires(s -> s.m_6761_(Config.getInstance().getPermission()))).then(Commands.m_82129_((String)"spawnCount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Integer spawnCount = (Integer)context.getArgument("spawnCount", Integer.class);
            LMSCommand.getAllLmsHandlers((CommandContext<CommandSourceStack>)context).forEach(l -> l.getSpawnerControl().setSpawnCount(spawnCount));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Changed spawnCount to " + spawnCount)), true);
            return 1;
        })));
        spawner.then(Commands.m_82127_((String)"query").executes(context -> {
            LMSHandler lmsHandler = LMSCommand.getLmsHandler((CommandContext<CommandSourceStack>)context);
            lmsHandler.getSpawnerControl().getMessages().forEach(s -> ((CommandSourceStack)context.getSource()).m_81354_(s, true));
            return 1;
        }));
        LiteralArgumentBuilder categoryLimit = Commands.m_82127_((String)"category_limit");
        categoryLimit.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(s -> s.m_6761_(Config.getInstance().getPermission()))).then(Commands.m_82129_((String)"category", (ArgumentType)EnumArgument.enumArgument(MobCategory.class)).then(Commands.m_82129_((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            MobCategory category = (MobCategory)context.getArgument("category", MobCategory.class);
            Integer limit = (Integer)context.getArgument("limit", Integer.class);
            LMSCommand.getAllLmsHandlers((CommandContext<CommandSourceStack>)context).forEach(l -> l.getMobNumberLimit().set(category, limit));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Set %s limit to %s".formatted(category, limit)), true);
            return 1;
        }))));
        categoryLimit.then(Commands.m_82127_((String)"query").executes(context -> {
            Optional<Component> message = LMSCommand.getLmsHandler((CommandContext<CommandSourceStack>)context).getMobNumberLimit().getMessage();
            message.ifPresent(m -> ((CommandSourceStack)context.getSource()).m_81354_(m, true));
            return 1;
        }));
        literal.then((ArgumentBuilder)categoryLimit);
        dispatcher.register(literal);
    }

    private static void registerQuery(LiteralArgumentBuilder<CommandSourceStack> parent, Function<CommandContext<CommandSourceStack>, LMSHandler> getter) {
        for (RuleType ruleType : RuleType.values()) {
            parent.then(Commands.m_82127_((String)ruleType.saveName()).executes(context -> {
                LMSHandler lmsHandler = (LMSHandler)getter.apply(context);
                LMSCommand.sendMessage((CommandContext<CommandSourceStack>)context, ruleType.getCommandName(), ruleType.getRules(lmsHandler));
                return 1;
            }));
        }
        parent.executes(context -> {
            LMSHandler lmsHandler = (LMSHandler)getter.apply(context);
            for (RuleType ruleType : RuleType.values()) {
                LMSCommand.sendMessage((CommandContext<CommandSourceStack>)context, ruleType.getCommandName(), ruleType.getRules(lmsHandler));
            }
            return 1;
        });
    }

    private static void sendMessage(CommandContext<CommandSourceStack> context, String s, Set<TestSpawn> conditions) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)(s + "=" + conditions.size())), true);
        conditions.stream().map(Object::toString).map(Component::m_237113_).forEach(c -> ((CommandSourceStack)context.getSource()).m_81354_((Component)c, true));
    }

    @Nonnull
    private static LMSHandler getLmsHandler(CommandContext<CommandSourceStack> context) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        return (LMSHandler)world.getCapability(Caps.getLmsCapability()).orElseGet(LMSConditionsHolder::new);
    }

    private static List<LMSHandler> getAllLmsHandlers(CommandContext<CommandSourceStack> context) {
        ArrayList<LMSHandler> list = new ArrayList<LMSHandler>();
        for (Level world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
            world.getCapability(Caps.getLmsCapability()).ifPresent(list::add);
        }
        return list;
    }
}

