/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu;

import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.moddingx.libx.fi.Function5;
import org.moddingx.libx.fi.Function6;
import org.moddingx.libx.menu.DefaultMenu;

public class BlockMenu
extends DefaultMenu {
    protected final BlockPos pos;

    public BlockMenu(@Nullable MenuType<? extends BlockMenu> type, int windowId, Level level, BlockPos pos, Inventory playerContainer, Player player, int firstOutputSlot, int firstInventorySlot) {
        super(type, windowId, level, playerContainer, player, firstOutputSlot, firstInventorySlot);
        this.pos = pos;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return BlockMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.pos), (Player)this.player, (Block)this.level.m_8055_(this.pos).m_60734_());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static <T extends BlockMenu> MenuType<T> createMenuType(Function5<Integer, Level, BlockPos, Inventory, Player, T> constructor) {
        return IForgeMenuType.create((windowId, inv, data) -> (BlockMenu)((Object)((Object)constructor.apply(windowId, inv.f_35978_.f_19853_, data.m_130135_(), inv, inv.f_35978_))));
    }

    public static <T extends BlockMenu> MenuType<T> createMenuType(Function6<MenuType<T>, Integer, Level, BlockPos, Inventory, Player, T> constructor) {
        AtomicReference<Object> typeRef = new AtomicReference<Object>(null);
        MenuType type = IForgeMenuType.create((windowId, inv, data) -> (BlockMenu)((Object)((Object)constructor.apply((MenuType)typeRef.get(), windowId, inv.f_35978_.f_19853_, data.m_130135_(), inv, inv.f_35978_))));
        typeRef.set(type);
        return type;
    }

    public static void openMenu(ServerPlayer player, final MenuType<? extends BlockMenu> menu, final Component title, final BlockPos pos) {
        MenuProvider containerProvider = new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return title;
            }

            public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.m_130064_(pos);
                return menu.create(containerId, inventory, buffer);
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, (BlockPos)pos);
    }
}

