/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.jcplugin;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import joptsimple.OptionSpecBuilder;
import net.jomcraft.jcplugin.ComparableVersion;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.jomcraft.jcplugin.JCLogger;

public class JCPlugin
implements ITransformationService {
    public static boolean checksSuccessful = false;

    public String name() {
        return "jcplugin";
    }

    public void initialize(IEnvironment environment) {
        try {
            if (this.getSideName().equals("CLIENT")) {
                String launchTarget = (String)environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).get();
                Path location = (Path)environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).get();
                FileUtilNoMC.mcDataDir = location.toFile();
                if (!launchTarget.contains("dev")) {
                    File mods = new File(FileUtilNoMC.mcDataDir, "mods");
                    for (File mod : mods.listFiles()) {
                        if (!mod.getName().toLowerCase().contains("defaultsettings")) continue;
                        JarFile jar = new JarFile(mod);
                        ZipEntry toml = jar.getEntry("META-INF/mods.toml");
                        if (toml != null) {
                            String readerLine;
                            BufferedReader result = new BufferedReader(new InputStreamReader(jar.getInputStream(toml)));
                            boolean containsDefaultSettings = false;
                            boolean versionsMatch = false;
                            while ((readerLine = result.readLine()) != null) {
                                if (readerLine.contains("modId=\"defaultsettings\"")) {
                                    containsDefaultSettings = true;
                                    continue;
                                }
                                if (!readerLine.contains("version=")) continue;
                                String version = readerLine.split("\"")[1];
                                versionsMatch = JCLogger.isEqualOrNewer(new ComparableVersion(version));
                            }
                            if (containsDefaultSettings && versionsMatch) {
                                checksSuccessful = true;
                            }
                            result.close();
                        }
                        jar.close();
                    }
                } else {
                    JCLogger.log.info("Loading DefaultSettings Core plugin in development environment");
                    checksSuccessful = true;
                }
                if (checksSuccessful) {
                    FileUtilNoMC.restoreContentsFirst();
                } else {
                    JCLogger.log.error("Could not find DefaultSettings, not going to do anything! Shutting down...");
                }
            }
        }
        catch (Exception e) {
            JCLogger.log.error((Object)e);
        }
    }

    public void beginScanning(IEnvironment environment) {
    }

    public String getSideName() {
        Environment environment = Launcher.INSTANCE.environment();
        String launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).orElse("missing").toLowerCase(Locale.ROOT);
        if (launchTarget.contains("server")) {
            return "SERVER";
        }
        if (launchTarget.contains("client")) {
            return "CLIENT";
        }
        Optional launchHandler = environment.findLaunchHandler(launchTarget);
        if (launchHandler.isPresent()) {
            ILaunchHandlerService service = (ILaunchHandlerService)launchHandler.get();
            try {
                Method mdGetDist = service.getClass().getDeclaredMethod("getDist", new Class[0]);
                String strDist = mdGetDist.invoke((Object)service, new Object[0]).toString().toLowerCase(Locale.ROOT);
                if (strDist.contains("server")) {
                    return "SERVER";
                }
                if (strDist.contains("client")) {
                    return "CLIENT";
                }
            }
            catch (Exception ex) {
                JCLogger.log.error((Object)ex);
                return null;
            }
        }
        return null;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
    }

    public List<ITransformer> transformers() {
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        return list;
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
    }

    public void argumentValues(ITransformationService.OptionResult option) {
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalClassesLocator() {
        return null;
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalResourcesLocator() {
        return null;
    }
}

