/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.network.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridClear;

public class TerminalStorageIngredientItemStackCraftingGridSetRecipe
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private boolean maxTransfer;
    private Map<Integer, Pair<ItemStack, Integer>> slottedIngredientsFromPlayer;
    private Map<Integer, List<Pair<ItemStack, Integer>>> slottedIngredientsFromStorage;

    public TerminalStorageIngredientItemStackCraftingGridSetRecipe() {
    }

    public TerminalStorageIngredientItemStackCraftingGridSetRecipe(String tabId, int channel, boolean maxTransfer, Map<Integer, Pair<ItemStack, Integer>> slottedIngredientsFromPlayer, Map<Integer, List<Pair<ItemStack, Integer>>> slottedIngredientsFromStorage) {
        this.tabId = tabId;
        this.channel = channel;
        this.maxTransfer = maxTransfer;
        this.slottedIngredientsFromPlayer = slottedIngredientsFromPlayer;
        this.slottedIngredientsFromStorage = slottedIngredientsFromStorage;
    }

    public void encode(FriendlyByteBuf output) {
        super.encode(output);
        output.writeInt(this.slottedIngredientsFromPlayer.size());
        for (Map.Entry<Integer, Pair<ItemStack, Integer>> entry : this.slottedIngredientsFromPlayer.entrySet()) {
            output.writeInt(entry.getKey().intValue());
            output.m_130055_((ItemStack)entry.getValue().getLeft());
            output.writeInt(((Integer)entry.getValue().getRight()).intValue());
        }
        output.writeInt(this.slottedIngredientsFromStorage.size());
        for (Map.Entry<Integer, Object> entry : this.slottedIngredientsFromStorage.entrySet()) {
            output.writeInt(entry.getKey().intValue());
            output.writeInt(((List)entry.getValue()).size());
            for (Pair subEntry : (List)entry.getValue()) {
                output.m_130055_((ItemStack)subEntry.getLeft());
                output.writeInt(((Integer)subEntry.getRight()).intValue());
            }
        }
    }

    public void decode(FriendlyByteBuf input) {
        super.decode(input);
        int entriesSlottedIngredientsFromPlayer = input.readInt();
        this.slottedIngredientsFromPlayer = Maps.newHashMap();
        for (int i = 0; i < entriesSlottedIngredientsFromPlayer; ++i) {
            this.slottedIngredientsFromPlayer.put(input.readInt(), (Pair<ItemStack, Integer>)Pair.of((Object)input.m_130267_(), (Object)input.readInt()));
        }
        int entriesSlottedIngredientsFromStorage = input.readInt();
        this.slottedIngredientsFromStorage = Maps.newHashMap();
        for (int i = 0; i < entriesSlottedIngredientsFromStorage; ++i) {
            int key = input.readInt();
            int entries = input.readInt();
            ArrayList alternatives = Lists.newArrayListWithExpectedSize((int)entries);
            for (int j = 0; j < entries; ++j) {
                alternatives.add(Pair.of((Object)input.m_130267_(), (Object)input.readInt()));
            }
            this.slottedIngredientsFromStorage.put(key, alternatives);
        }
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ContainerTerminalStorageBase container;
        ITerminalStorageTabCommon tabCommon;
        if (player.f_36096_ instanceof ContainerTerminalStorageBase && (tabCommon = (container = (ContainerTerminalStorageBase)player.f_36096_).getTabCommon(this.tabId)) instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            Slot slot;
            TerminalStorageTabIngredientComponentServer tabServerCrafting = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            int slotOffset = tabCommonCrafting.getSlotCrafting().f_40219_;
            TerminalStorageIngredientItemStackCraftingGridClear.clearGrid(tabCommonCrafting, tabServerCrafting, this.channel, true, (Player)player);
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper playerInventory = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new InvWrapper((Container)player.m_150109_()));
            for (Map.Entry<Integer, Pair<ItemStack, Integer>> entry : this.slottedIngredientsFromPlayer.entrySet()) {
                Integer matchCondition = (Integer)entry.getValue().getRight();
                ItemStack extracted = playerInventory.extract((ItemStack)entry.getValue().getLeft(), matchCondition, false);
                slot = container.m_38853_(entry.getKey() + slotOffset);
                slot.m_5852_(extracted);
            }
            IIngredientComponentStorage storage = tabServerCrafting.getIngredientNetwork().getChannel(this.channel);
            for (Map.Entry<Integer, List<Pair<ItemStack, Integer>>> entry : this.slottedIngredientsFromStorage.entrySet()) {
                int slotId = entry.getKey() + slotOffset;
                slot = container.m_38853_(slotId);
                if (slot.m_6657_()) continue;
                ItemStack extracted = ItemStack.f_41583_;
                for (Pair<ItemStack, Integer> stackEntry : entry.getValue()) {
                    int matchCondition = (Integer)stackEntry.getRight();
                    extracted = (ItemStack)storage.extract((Object)((ItemStack)stackEntry.getLeft()), (Object)matchCondition, false);
                    if (extracted.m_41619_()) continue;
                    break;
                }
                if (extracted.m_41619_()) continue;
                slot.m_5852_(extracted);
            }
        }
    }
}

