/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.part;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.part.PartTypeTerminal;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class PartTypeTerminalStorage
extends PartTypeTerminal<PartTypeTerminalStorage, State> {
    public PartTypeTerminalStorage(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.terminalStorageBaseConsumption;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)PartTypeTerminalStorage.this.getTranslationKey());
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State state = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                TerminalStorageState terminalStorageState = state.getPlayerStorageState(playerEntity);
                return new ContainerTerminalStoragePart(id, playerInventory, (PartTarget)data.getRight(), (PartTypeTerminalStorage)((Object)data.getMiddle()), Optional.empty(), terminalStorageState);
            }
        });
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
        packetBuffer.writeBoolean(false);
        State state = (State)PartHelpers.getPartContainerChecked((PartPos)pos).getPartState(pos.getSide());
        TerminalStorageState terminalStorageState = state.getPlayerStorageState((Player)player);
        terminalStorageState.writeToPacketBuffer(packetBuffer);
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (Map.Entry<String, NonNullList<ItemStack>> entry : state.getNamedInventories().entrySet()) {
            if (entry.getKey().equals(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
                entry.getValue().set(0, (Object)ItemStack.f_41583_);
            }
            for (ItemStack itemStack : entry.getValue()) {
                if (itemStack.m_41619_()) continue;
                itemStacks.add(itemStack);
            }
        }
        state.clearNamedInventories();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateEmpty<PartTypeTerminalStorage>
    implements ITerminalStorageTabCommon.IVariableInventory {
        private final Map<String, NonNullList<ItemStack>> namedInventories = Maps.newHashMap();
        private final Map<String, TerminalStorageState> playerStorageStates = Maps.newHashMap();

        public int getUpdateInterval() {
            return 1;
        }

        public void clearNamedInventories() {
            this.namedInventories.clear();
        }

        @Override
        public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
            this.namedInventories.put(name, inventory);
            this.onDirty();
        }

        public Map<String, NonNullList<ItemStack>> getNamedInventories() {
            return this.namedInventories;
        }

        @Override
        @Nullable
        public NonNullList<ItemStack> getNamedInventory(String name) {
            return this.namedInventories.get(name);
        }

        public TerminalStorageState getPlayerStorageState(Player player) {
            TerminalStorageState state = this.playerStorageStates.get(player.m_20148_().toString());
            if (state == null) {
                state = TerminalStorageState.getPlayerDefault(player, (IDirtyMarkListener)this);
                this.playerStorageStates.put(player.m_20148_().toString(), state);
                this.onDirty();
            }
            return state;
        }

        public void writeToNBT(CompoundTag tag) {
            super.writeToNBT(tag);
            ListTag namedInventoriesList = new ListTag();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.namedInventories.entrySet()) {
                CompoundTag listEntry = new CompoundTag();
                listEntry.m_128359_("tabName", entry.getKey());
                listEntry.m_128405_("itemCount", entry.getValue().size());
                ContainerHelper.m_18973_((CompoundTag)listEntry, entry.getValue());
                namedInventoriesList.add((Object)listEntry);
            }
            tag.m_128365_("namedInventories", (Tag)namedInventoriesList);
            ListTag playerStorageStatesList = new ListTag();
            for (Map.Entry<String, TerminalStorageState> entry : this.playerStorageStates.entrySet()) {
                CompoundTag stateEntry = new CompoundTag();
                stateEntry.m_128359_("player", entry.getKey());
                stateEntry.m_128365_("value", (Tag)entry.getValue().getTag());
                playerStorageStatesList.add((Object)stateEntry);
            }
            tag.m_128365_("playerStorageStates", (Tag)playerStorageStatesList);
        }

        public void readFromNBT(CompoundTag tag) {
            super.readFromNBT(tag);
            for (Tag listEntry : tag.m_128437_("namedInventories", 10)) {
                NonNullList list = NonNullList.m_122780_((int)((CompoundTag)listEntry).m_128451_("itemCount"), (Object)ItemStack.f_41583_);
                String tabName = ((CompoundTag)listEntry).m_128461_("tabName");
                ContainerHelper.m_18980_((CompoundTag)((CompoundTag)listEntry), (NonNullList)list);
                this.namedInventories.put(tabName, (NonNullList<ItemStack>)list);
            }
            for (Tag listEntry : tag.m_128437_("playerStorageStates", 10)) {
                String playerName = ((CompoundTag)listEntry).m_128461_("player");
                TerminalStorageState state = new TerminalStorageState(((CompoundTag)listEntry).m_128469_("value"), (IDirtyMarkListener)this);
                this.playerStorageStates.put(playerName, state);
            }
        }
    }
}

