/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.commoncapabilities.api.ingredient.storage.IngredientComponentStorageEmpty;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.network.IFullNetworkListener;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapterWrapperSlotted;
import org.cyclops.integrateddynamics.core.network.IngredientChannelIndexed;
import org.cyclops.integrateddynamics.core.network.IngredientObserver;
import org.cyclops.integrateddynamics.core.network.IngredientPositionsIndex;
import org.cyclops.integrateddynamics.core.network.IngredientPositionsIndexEmpty;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetwork;

public abstract class PositionedAddonsNetworkIngredients<T, M>
extends PositionedAddonsNetwork
implements IPositionedAddonsNetworkIngredients<T, M>,
IFullNetworkListener,
IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> {
    private final IngredientComponent<T, M> component;
    private final IngredientObserver<T, M> ingredientObserver;
    private final Int2ObjectMap<IngredientPositionsIndex<T, M>> indexes;
    private final Map<PartPos, PositionedAddonsNetworkIngredientsFilter<T>> positionFilters = Maps.newHashMap();
    private final LoadingCache<PartPos, IIngredientComponentStorage<T, M>> cacheStorage;
    private final Int2IntMap cacheChannelSlots;
    private boolean observe;
    private Map<PartPos, Long> lastSecondDurations = Maps.newHashMap();

    public PositionedAddonsNetworkIngredients(IngredientComponent<T, M> component) {
        this.component = component;
        this.ingredientObserver = new IngredientObserver(this);
        this.ingredientObserver.addChangeObserver(this);
        this.indexes = new Int2ObjectOpenHashMap();
        this.cacheStorage = CacheBuilder.newBuilder().build(new CacheLoader<PartPos, IIngredientComponentStorage<T, M>>(){

            public IIngredientComponentStorage<T, M> load(PartPos pos) {
                IngredientComponentStorageEmpty storage = PositionedAddonsNetworkIngredients.this.getPositionedStorageUnsafe(pos);
                return storage == null ? new IngredientComponentStorageEmpty(PositionedAddonsNetworkIngredients.this.getComponent()) : storage;
            }
        });
        this.cacheChannelSlots = new Int2IntLinkedOpenHashMap();
        this.observe = false;
    }

    @Override
    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    @Override
    public IIngredientComponentStorage<T, M> getPositionedStorage(PartPos pos) {
        try {
            return (IIngredientComponentStorage)this.cacheStorage.get((Object)pos);
        }
        catch (ExecutionException e) {
            return new IngredientComponentStorageEmpty(this.getComponent());
        }
    }

    @Nullable
    public IIngredientPositionsIndex<T, M> getInstanceLocationsIndex(int channel) {
        return (IIngredientPositionsIndex)this.indexes.get(channel);
    }

    @Override
    public boolean addPosition(PartPos pos, int priority, int channel) {
        return this.getPositionedStorageUnsafe(pos) != null && super.addPosition(pos, priority, channel);
    }

    @Override
    public void setPositionedStorageFilter(PartPos pos, @Nullable PositionedAddonsNetworkIngredientsFilter<T> filter) {
        if (filter == null) {
            this.positionFilters.remove(pos);
        } else {
            this.positionFilters.put(pos, filter);
        }
    }

    @Override
    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<T> getPositionedStorageFilter(PartPos pos) {
        return this.positionFilters.get(pos);
    }

    @Override
    public void onChange(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        this.applyChangesToChannel(event, event.getChannel());
        this.applyChangesToChannel(event, -1);
        if (GeneralConfig.logChangeEvents) {
            System.out.println(this.toString() + event);
        }
    }

    protected void applyChangesToChannel(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event, int channel) {
        IIngredientCollection<T, M> instances = event.getInstances();
        PrioritizedPartPos pos = event.getPos();
        IngredientPositionsIndex<T, M> index = this.getIndexSafe(channel);
        if (event.getChangeType() == IIngredientComponentStorageObservable.Change.DELETION) {
            index.removeAll(pos, (Iterable<T>)instances);
            if (event.isCompleteChange()) {
                for (Object instance : instances) {
                    index.removePosition(instance, pos);
                }
            }
            if (index.isEmpty()) {
                this.indexes.remove(channel);
            }
        } else if (event.getChangeType() == IIngredientComponentStorageObservable.Change.ADDITION) {
            index.addAll(pos, (Iterable<T>)instances);
            for (Object instance : instances) {
                index.addPosition(instance, pos);
            }
        }
    }

    protected IngredientPositionsIndex<T, M> getIndexSafe(int channel) {
        IngredientPositionsIndex<T, M> index = (IngredientPositionsIndex<T, M>)this.indexes.get(channel);
        if (index == null) {
            index = new IngredientPositionsIndex<T, M>(this.getComponent());
            this.indexes.put(channel, index);
        }
        return index;
    }

    @Override
    protected void onPositionAdded(int channel, PrioritizedPartPos pos) {
        super.onPositionAdded(channel, pos);
        List<PrioritizedPartPos> lastRemoved = this.ingredientObserver.getLastRemoved(channel);
        if (lastRemoved != null) {
            lastRemoved.remove(pos);
        }
    }

    @Override
    protected void onPositionRemoved(int channel, PrioritizedPartPos pos) {
        super.onPositionRemoved(channel, pos);
        this.ingredientObserver.onPositionRemoved(channel, pos);
    }

    @Override
    public IIngredientComponentStorage<T, M> getChannel(int channel) {
        return new IngredientChannelIndexed<T, M>(this, channel, this.getChannelIndex(channel));
    }

    @Override
    public void addObserver(IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer) {
        this.ingredientObserver.addChangeObserver(observer);
    }

    @Override
    public void removeObserver(IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> observer) {
        this.ingredientObserver.removeChangeObserver(observer);
    }

    @Override
    public void scheduleObservation() {
        this.observe = true;
    }

    @Override
    public void scheduleObservationForced(int channel, PartPos pos) {
        this.scheduleObservation();
        if (channel == -1) {
            this.ingredientObserver.resetTickInterval(this.getPositionChannel(pos), pos);
        } else {
            this.ingredientObserver.resetTickInterval(channel, pos);
        }
    }

    @Override
    public boolean shouldObserve() {
        return this.observe;
    }

    @Override
    public boolean isObservationForcedPending(int channel) {
        if (channel == -1) {
            for (int channelActual : this.getChannels()) {
                if (!this.ingredientObserver.isTickResetPending(channelActual)) continue;
                return true;
            }
            return false;
        }
        return this.ingredientObserver.isTickResetPending(channel);
    }

    @Override
    public void runObserverSync() {
        if (this.ingredientObserver.observe(true)) {
            this.observe = false;
        }
    }

    @Override
    public IIngredientPositionsIndex<T, M> getChannelIndex(int channel) {
        IIngredientPositionsIndex<T, M> index = this.getInstanceLocationsIndex(channel);
        if (index == null) {
            index = new IngredientPositionsIndexEmpty<T, M>(this.getComponent());
        }
        return index;
    }

    @Override
    @Nullable
    public <S> S getChannelExternal(Capability<S> capability, int channel) {
        IIngredientComponentStorageWrapperHandler wrapperHandler = this.getComponent().getStorageWrapperHandler(capability);
        return (S)(wrapperHandler != null ? wrapperHandler.wrapStorage(new IngredientChannelAdapterWrapperSlotted((IngredientChannelAdapter)this.getChannel(channel), this.cacheChannelSlots)) : null);
    }

    @Override
    public boolean addNetworkElement(INetworkElement element, boolean networkPreinit) {
        return true;
    }

    @Override
    public boolean removeNetworkElementPre(INetworkElement element) {
        return true;
    }

    @Override
    public void removeNetworkElementPost(INetworkElement element) {
    }

    @Override
    public void kill() {
    }

    @Override
    public void updateGuaranteed() {
    }

    @Override
    public void update() {
        if (this.shouldObserve() && this.ingredientObserver.observe(false)) {
            this.observe = false;
        }
        this.cacheStorage.invalidateAll();
        this.cacheChannelSlots.clear();
    }

    @Override
    public boolean removePathElement(IPathElement pathElement, Direction side) {
        return true;
    }

    @Override
    public void afterServerLoad() {
    }

    @Override
    public void beforeServerStop() {
    }

    @Override
    public boolean canUpdate(INetworkElement element) {
        return true;
    }

    @Override
    public void onSkipUpdate(INetworkElement element) {
    }

    @Override
    public void postUpdate(INetworkElement element) {
    }

    @Override
    public Map<PartPos, Long> getLastSecondDurationIndex() {
        return this.lastSecondDurations;
    }

    @Override
    public void resetLastSecondDurationsIndex() {
        this.lastSecondDurations.clear();
    }

    @Override
    public void invalidateElement(INetworkElement element) {
    }

    @Override
    public void revalidateElement(INetworkElement element) {
    }
}

