/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class VariableFacadeBase
implements IVariableFacade {
    private final int id;

    public VariableFacadeBase(boolean generateId) {
        this.id = generateId ? VariableFacadeBase.generateId() : -1;
    }

    public static int generateId() {
        return IntegratedDynamics.globalCounters.getNext("variable");
    }

    @Override
    public String getLabel() {
        return LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(this.getId());
    }

    protected String getReferenceDisplay(int variableId) {
        String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(variableId);
        if (label == null) {
            return String.valueOf(variableId);
        }
        return String.format("%s:%s", label, variableId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Level world) {
        list.add((Component)Component.m_237110_((String)"item.integrateddynamics.variable.id", (Object[])new Object[]{this.getId() == -1 ? "..." : Integer.valueOf(this.getId())}));
    }

    public VariableFacadeBase(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableFacadeBase)) {
            return false;
        }
        VariableFacadeBase other = (VariableFacadeBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableFacadeBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        return result;
    }

    public String toString() {
        return "VariableFacadeBase(id=" + this.getId() + ")";
    }
}

