/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityBase;

public abstract class ValueTypeListProxyEntityCapability<C, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyEntityBase<T, V> {
    private final Capability<C> capability;
    private Direction side;

    public ValueTypeListProxyEntityCapability(ResourceLocation name, T valueType, Level world, Entity entity, Capability<C> capability, @Nullable Direction side) {
        super(name, valueType, world, entity);
        this.capability = capability;
        this.side = side;
    }

    protected LazyOptional<C> getCapability() {
        Entity e = this.getEntity();
        if (e != null) {
            return e.getCapability(this.capability, this.side);
        }
        return LazyOptional.empty();
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag) {
        super.writeGeneratedFieldsToNBT(tag);
        if (this.side != null) {
            tag.m_128405_("side", this.side.ordinal());
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag) {
        super.readGeneratedFieldsFromNBT(tag);
        if (tag.m_128425_("side", 3)) {
            this.side = Direction.values()[tag.m_128451_("side")];
        }
    }
}

