/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class MessagePowerpackAntenna
implements IMessage {
    UUID player;
    boolean remove = false;
    BlockPos from;
    BlockPos to;

    public MessagePowerpackAntenna(Player player, @Nullable Connection connection) {
        this.player = player.m_20148_();
        if (connection == null) {
            this.remove = true;
        } else {
            this.from = connection.getEndA().position();
            this.to = connection.getEndB().position();
        }
    }

    public MessagePowerpackAntenna(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.remove = buf.readBoolean();
        if (!this.remove) {
            this.from = buf.m_130135_();
            this.to = buf.m_130135_();
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.writeBoolean(this.remove);
        if (!this.remove) {
            buf.m_130064_(this.from);
            buf.m_130064_(this.to);
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null) {
                if (this.remove) {
                    ModelPowerpack.PLAYER_ATTACHED_TO.remove(this.player);
                } else {
                    GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
                    global.getLocalNet(this.from).getConnections(this.from).stream().filter(conn -> conn.getEndA().position().equals((Object)this.from) && conn.getEndB().position().equals((Object)this.to) || conn.getEndB().position().equals((Object)this.from) && conn.getEndA().position().equals((Object)this.to)).findFirst().ifPresent(c -> ModelPowerpack.PLAYER_ATTACHED_TO.put(this.player, (Connection)c));
                }
            }
        });
    }
}

