/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkHooks;

public class IEBaseItem
extends Item {
    private int burnTime = -1;
    private boolean isHidden = false;

    public IEBaseItem() {
        this(new Item.Properties());
    }

    public IEBaseItem(Item.Properties props) {
        this(props, ImmersiveEngineering.ITEM_GROUP);
    }

    public IEBaseItem(Item.Properties props, CreativeModeTab group) {
        super(props.m_41491_(group));
    }

    public IEBaseItem setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    protected void openGui(Player player, InteractionHand hand) {
        this.openGui(player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    protected void openGui(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        IEMenuTypes.ItemContainerTypeNew<?> typeNew = this.getContainerTypeNew();
        if (typeNew != null) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> typeNew.create(id, inv, slot, stack), (Component)Component.m_237119_()));
        } else {
            IEMenuTypes.ItemContainerType<?> typeOld = this.getContainerType();
            if (typeOld != null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> typeOld.create(id, inv, player.f_19853_, slot, stack), (Component)Component.m_237119_()), buffer -> buffer.writeInt(slot.ordinal()));
            }
        }
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isIERepairable(@Nonnull ItemStack stack) {
        return super.isRepairable(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return null;
    }

    @Nullable
    protected IEMenuTypes.ItemContainerTypeNew<?> getContainerTypeNew() {
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return Mob.m_147233_((ItemStack)stack) == armorType || this.getEquipmentSlot(stack) == armorType;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

