/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;

public class MetalPressPackingRecipes {
    public static final CachedRecipeList<CraftingRecipe> CRAFTING_RECIPE_MAP = new CachedRecipeList<CraftingRecipe>(() -> RecipeType.f_44107_, CraftingRecipe.class);
    public static final ResourceLocation UNPACK_ID = ImmersiveEngineering.rl("unpacking");
    public static final ResourceLocation PACK4_ID = ImmersiveEngineering.rl("packing4");
    public static final ResourceLocation PACK9_ID = ImmersiveEngineering.rl("packing9");
    private static final HashMap<ComparableItemStack, RecipeDelegate> UNPACKING_CACHE = new HashMap();

    public static void init() {
        MetalPressRecipe.addSpecialRecipe(new MetalPressPackingRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing2x2"), IEItems.Molds.MOLD_PACKING_4.m_5456_(), 2));
        MetalPressRecipe.addSpecialRecipe(new MetalPressPackingRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing3x3"), IEItems.Molds.MOLD_PACKING_9.m_5456_(), 3));
        MetalPressRecipe.addSpecialRecipe(new MetalPressContainerRecipe(new ResourceLocation("immersiveengineering", "metalpress/unpacking"), IEItems.Molds.MOLD_UNPACKING.m_5456_()){

            @Override
            protected MetalPressRecipe getRecipeFunction(ItemStack input, Level world) {
                return MetalPressPackingRecipes.getUnpackingCached(input, world);
            }
        });
    }

    @Nullable
    public static RecipeDelegate getRecipeDelegate(CraftingRecipe recipe, ResourceLocation id) {
        NonNullList ingredients = recipe.m_7527_();
        if (ingredients.isEmpty() || ((Ingredient)ingredients.get(0)).m_43947_()) {
            return null;
        }
        ItemStack input = ((Ingredient)ingredients.get(0)).m_43908_()[0];
        if (PACK4_ID.equals((Object)id)) {
            if (ingredients.size() == 4) {
                return RecipeDelegate.getPacking((Pair<CraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.m_8043_()), input, false);
            }
        } else if (PACK9_ID.equals((Object)id)) {
            if (ingredients.size() == 9) {
                return RecipeDelegate.getPacking((Pair<CraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.m_8043_()), input, true);
            }
        } else if (UNPACK_ID.equals((Object)id) && ingredients.size() == 1) {
            return RecipeDelegate.getUnpacking((Pair<CraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.m_8043_()), input);
        }
        return null;
    }

    public static Pair<CraftingRecipe, ItemStack> getPackedOutput(int gridSize, ItemStack stack, Level world) {
        CraftingContainer invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.m_122780_((int)(gridSize * gridSize), (Object)stack.m_41777_()));
        return world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)invC, world).map(recipe -> Pair.of((Object)recipe, (Object)recipe.m_5874_((Container)invC))).orElse(null);
    }

    private static RecipeDelegate getUnpackingCached(ItemStack input, Level world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (UNPACKING_CACHE.containsKey(comp)) {
            return UNPACKING_CACHE.get(comp);
        }
        comp.copy();
        Pair<CraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(1, input, world);
        if (out == null) {
            return null;
        }
        ItemStack outStack = (ItemStack)out.getSecond();
        int count = outStack.m_41613_();
        if (count != 4 && count != 9) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        Pair<CraftingRecipe, ItemStack> rePacked = MetalPressPackingRecipes.getPackedOutput(count == 4 ? 2 : 3, outStack, world);
        ItemStack singleInput = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1);
        if (rePacked == null || ((ItemStack)rePacked.getSecond()).m_41619_() || !ItemStack.m_41728_((ItemStack)singleInput, (ItemStack)((ItemStack)rePacked.getSecond()))) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        RecipeDelegate delegate = RecipeDelegate.getUnpacking(out, singleInput);
        UNPACKING_CACHE.put(comp, delegate);
        return delegate;
    }

    public static class MetalPressPackingRecipe
    extends MetalPressContainerRecipe {
        private final int size;
        private final Map<ComparableItemStack, RecipeDelegate> PACKING_CACHE = new HashMap<ComparableItemStack, RecipeDelegate>();

        public MetalPressPackingRecipe(ResourceLocation id, Item mold, int size) {
            super(id, mold);
            this.size = size;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, Level world) {
            return input.m_41613_() >= this.size * this.size && super.matches(mold, input, world);
        }

        @Override
        protected MetalPressRecipe getRecipeFunction(ItemStack input, Level world) {
            ComparableItemStack comp = new ComparableItemStack(input, false);
            if (this.PACKING_CACHE.containsKey(comp)) {
                return this.PACKING_CACHE.get(comp);
            }
            int totalSize = this.size * this.size;
            comp.copy();
            Pair<CraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(this.size, input, world);
            if (out == null) {
                return null;
            }
            ItemStack outStack = (ItemStack)out.getSecond();
            if (outStack.m_41619_()) {
                this.PACKING_CACHE.put(comp, null);
                return null;
            }
            RecipeDelegate delegate = RecipeDelegate.getPacking(out, ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)totalSize), this.size == 3);
            this.PACKING_CACHE.put(comp, delegate);
            return delegate;
        }
    }

    public static class RecipeDelegate
    extends MetalPressRecipe {
        public final CraftingRecipe baseRecipe;

        private RecipeDelegate(ResourceLocation id, ItemStack output, ItemStack input, Item mold, CraftingRecipe baseRecipe) {
            super(id, (Lazy<ItemStack>)Lazy.of(() -> output), IngredientWithSize.of(input), mold, 3200);
            this.baseRecipe = baseRecipe;
        }

        public static RecipeDelegate getPacking(Pair<CraftingRecipe, ItemStack> originalRecipe, ItemStack input, boolean big) {
            ItemStack output = (ItemStack)originalRecipe.getSecond();
            input = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)(big ? 9 : 4));
            return new RecipeDelegate(big ? PACK9_ID : PACK4_ID, output, input, (Item)(big ? IEItems.Molds.MOLD_PACKING_9 : IEItems.Molds.MOLD_PACKING_4).get(), (CraftingRecipe)originalRecipe.getFirst());
        }

        public static RecipeDelegate getUnpacking(Pair<CraftingRecipe, ItemStack> originalRecipe, ItemStack input) {
            ItemStack output = (ItemStack)originalRecipe.getSecond();
            return new RecipeDelegate(UNPACK_ID, output, input, (Item)IEItems.Molds.MOLD_UNPACKING.get(), (CraftingRecipe)originalRecipe.getFirst());
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }

    public static abstract class MetalPressContainerRecipe
    extends MetalPressRecipe {
        public MetalPressContainerRecipe(ResourceLocation id, Item mold) {
            super(id, (Lazy<ItemStack>)LAZY_EMPTY, new IngredientWithSize(Ingredient.f_43901_), mold, 3200);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, Level world) {
            return this.getRecipeFunction(input, world) != null;
        }

        @Override
        public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, Level world) {
            return this.getRecipeFunction(input, world);
        }

        protected abstract MetalPressRecipe getRecipeFunction(ItemStack var1, Level var2);
    }
}

