/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen.base;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.widgets.SelectionCircleWidget;
import terrails.healthoverlay.config.screen.widgets.TinyButton;
import terrails.healthoverlay.utilities.Vec2i;

public abstract class AbstractPlacementScreen
extends Screen {
    private static final Predicate<String> NUMBER_FILTER = text -> text.matches("-?[0-9]+");
    private final Screen lastScreen;
    private final SelectionCircleWidget[] selectionCircles = new SelectionCircleWidget[9];
    private EditBox xPos;
    private EditBox yPos;

    public AbstractPlacementScreen(Screen lastScreen, Component component) {
        super(component);
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        int BOX_WIDTH = this.f_96547_.m_92895_("-ABCDEF");
        Objects.requireNonNull(this.f_96547_);
        this.xPos = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ - 80 - BOX_WIDTH, this.f_96544_ - 15, BOX_WIDTH, 9 + 2, (Component)Component.m_237119_()));
        this.xPos.m_94153_(NUMBER_FILTER);
        this.xPos.m_94151_(text -> {
            int value;
            Configuration.RelativeTo relativeTo = this.getRelativeTo();
            int clamped = relativeTo.clampHorizontalCoordinates(value = Integer.parseInt(text), this.getMovableWidth());
            if (clamped != value) {
                this.xPos.m_94144_(Integer.toString(clamped));
            }
            int x = relativeTo.rootCoordinates().move(clamped, 0).getX();
            this.setMovableX(x);
        });
        this.setCoordinateX(this.getCoordinateX());
        Objects.requireNonNull(this.f_96547_);
        this.yPos = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ - 76, this.f_96544_ - 15, BOX_WIDTH, 9 + 2, (Component)Component.m_237119_()));
        this.yPos.m_94153_(NUMBER_FILTER);
        this.yPos.m_94151_(text -> {
            int value;
            Configuration.RelativeTo relativeTo = this.getRelativeTo();
            int clamped = relativeTo.clampVerticalCoordinates(value = Integer.parseInt(text), this.getMovableHeight());
            if (clamped != value) {
                this.yPos.m_94144_(Integer.toString(clamped));
            }
            int y = relativeTo.rootCoordinates().move(0, clamped).getY();
            this.setMovableY(y);
        });
        this.setCoordinateY(this.getCoordinateY());
        this.m_142416_((GuiEventListener)new TinyButton(27, this.f_96544_ - 18, 32, 12, button -> this.loadDefaults()));
        Configuration.RelativeTo relativeTo = this.getRelativeTo();
        this.selectionCircles[0] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(0, 0, 6, 6, 7, 7, Configuration.RelativeTo.TOP_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[1] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget((this.f_96543_ - 1) / 2 - 6, 0, 0, 6, 13, 7, Configuration.RelativeTo.TOP_MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[2] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(this.f_96543_ - 7, 0, 0, 6, 7, 7, Configuration.RelativeTo.TOP_RIGHT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[3] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(0, (this.f_96544_ - 1) / 2 - 6, 6, 0, 7, 13, Configuration.RelativeTo.MIDDLE_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[4] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget((this.f_96543_ - 1) / 2 - 6, (this.f_96544_ - 1) / 2 - 6, 0, 0, 13, 13, Configuration.RelativeTo.MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[5] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(this.f_96543_ - 7, (this.f_96544_ - 1) / 2 - 6, 0, 0, 7, 13, Configuration.RelativeTo.MIDDLE_RIGHT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[6] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(0, this.f_96544_ - 7, 6, 0, 7, 7, Configuration.RelativeTo.BOTTOM_LEFT, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[7] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget((this.f_96543_ - 1) / 2 - 6, this.f_96544_ - 7, 0, 0, 13, 7, Configuration.RelativeTo.BOTTOM_MIDDLE, relativeTo, this::updateCoordinatesToRelative));
        this.selectionCircles[8] = (SelectionCircleWidget)this.m_142416_((GuiEventListener)new SelectionCircleWidget(this.f_96543_ - 7, this.f_96544_ - 7, 0, 0, 7, 7, Configuration.RelativeTo.BOTTOM_RIGHT, relativeTo, this::updateCoordinatesToRelative));
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.saveValuesToConfig();
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.haveValuesChanged()) {
            this.setRelativeTo(this.configRelativeTo().get());
            this.setCoordinateX(this.configCoordinateX().get());
            this.setCoordinateY(this.configCoordinateY().get());
            assert (this.f_96541_ != null);
            SoundManager sm = this.f_96541_.m_91106_();
            sm.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public int getCoordinateX() {
        if (this.xPos == null || this.xPos.m_94155_().isEmpty()) {
            return this.configCoordinateX().get();
        }
        return Integer.parseInt(this.xPos.m_94155_());
    }

    public void setCoordinateX(int x) {
        this.xPos.m_94144_(Integer.toString(x));
    }

    public int getCoordinateY() {
        if (this.yPos == null || this.yPos.m_94155_().isEmpty()) {
            return this.configCoordinateY().get();
        }
        return Integer.parseInt(this.yPos.m_94155_());
    }

    public void setCoordinateY(int y) {
        this.yPos.m_94144_(Integer.toString(y));
    }

    public Configuration.RelativeTo getRelativeTo() {
        return Arrays.stream(this.selectionCircles).filter(Objects::nonNull).filter(SelectionCircleWidget::isActivated).map(SelectionCircleWidget::getRelativeTo).findAny().orElse(this.configRelativeTo().get());
    }

    public void setRelativeTo(Configuration.RelativeTo relativeTo) {
        Arrays.stream(this.selectionCircles).filter(Objects::nonNull).forEach(widget -> widget.updateActivated(relativeTo));
    }

    public void updateCoordinatesToRelative(Configuration.RelativeTo relativeTo) {
        int x = this.getCoordinateX();
        int y = this.getCoordinateY();
        Vec2i clamped = relativeTo.clampCoordinates(x, y, this.getMovableWidth(), this.getMovableHeight());
        Vec2i root = relativeTo.rootCoordinates();
        this.setRelativeTo(relativeTo);
        this.setCoordinateX(clamped.getX());
        this.setCoordinateY(clamped.getY());
        this.setMovableX(root.getX() + clamped.getX());
        this.setMovableY(root.getY() + clamped.getY());
    }

    public boolean haveValuesChanged() {
        Configuration.RelativeTo configRelativeTo = this.configRelativeTo().get();
        int configX = this.configCoordinateX().get();
        int configY = this.configCoordinateY().get();
        Configuration.RelativeTo relativeTo = this.getRelativeTo();
        int x = this.getCoordinateX();
        int y = this.getCoordinateY();
        return configRelativeTo != relativeTo || configX != x || configY != y;
    }

    public void saveValuesToConfig() {
        if (this.haveValuesChanged()) {
            this.configRelativeTo().set(this.getRelativeTo());
            this.configCoordinateX().set(this.getCoordinateX());
            this.configCoordinateY().set(this.getCoordinateY());
        }
    }

    public void loadDefaults() {
        Configuration.RelativeTo relativeTo = this.configRelativeTo().getDefault();
        int x = this.configCoordinateX().getDefault();
        int y = this.configCoordinateY().getDefault();
        this.setRelativeTo(relativeTo);
        this.setCoordinateX(x);
        this.setCoordinateY(y);
    }

    public abstract int getMovableWidth();

    public abstract int getMovableHeight();

    public abstract void setMovableX(int var1);

    public abstract void setMovableY(int var1);

    public abstract ConfigOption<Configuration.RelativeTo> configRelativeTo();

    public abstract ConfigOption<Integer> configCoordinateX();

    public abstract ConfigOption<Integer> configCoordinateY();
}

