/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.codec;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import shadows.gateways.Gateways;
import shadows.placebo.codec.PlaceboCodecs;

public class GatewayCodecs {
    public static <V extends PlaceboCodecs.CodecProvider<V>> Codec<V> mapBacked(String name, BiMap<ResourceLocation, Codec<? extends V>> reg) {
        return new NamespaceDefaultedMapBackedCodec<V>(name, reg);
    }

    public static class NamespaceDefaultedMapBackedCodec<V extends PlaceboCodecs.CodecProvider<V>>
    extends PlaceboCodecs.MapBackedCodec<V> {
        public NamespaceDefaultedMapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry) {
            super(name, registry);
        }

        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            Object typeObj = ops.get(input, "type").get().left().get();
            String typeStr = (String)ops.getStringValue(typeObj).getOrThrow(false, arg_0 -> ((Logger)Gateways.LOGGER).error(arg_0));
            ResourceLocation type = typeStr.indexOf(58) == -1 ? Gateways.loc(typeStr) : new ResourceLocation(typeStr);
            Codec codec = (Codec)this.registry.get((Object)type);
            if (codec == null) {
                return DataResult.error((String)("Failure when parsing a " + this.name + ". Unrecognized type: " + type));
            }
            return codec.decode(ops, input);
        }
    }
}

