/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;

public class FluxUtils {
    private static final double[] COMPACT_SCALE = new double[]{0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18};
    public static final Direction[] DIRECTIONS = Direction.values();

    private FluxUtils() {
    }

    @Nonnull
    public static <E extends Enum<E>> E cycle(@Nonnull E val, @Nonnull E[] values) {
        int next = val.ordinal() + 1;
        if (next < values.length) {
            return values[next];
        }
        return values[0];
    }

    @Nullable
    public static Direction getBlockDirection(@Nonnull BlockPos base, @Nonnull BlockPos target) {
        if (base.equals((Object)target)) {
            return null;
        }
        BlockPos.MutableBlockPos test = new BlockPos.MutableBlockPos();
        for (Direction dir : DIRECTIONS) {
            test.m_122190_((Vec3i)base);
            if (!test.m_122173_(dir).equals((Object)target)) continue;
            return dir;
        }
        return null;
    }

    @Nonnull
    public static String getTransferInfo(@Nonnull IFluxDevice flux, EnergyType energyType) {
        FluxDeviceType type = flux.getDeviceType();
        long change = flux.getTransferChange();
        if (type.isPlug()) {
            if (change == 0L) {
                return FluxTranslate.INPUT.get() + ": " + ChatFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.INPUT.get() + ": " + ChatFormatting.GREEN + "+" + energyType.getUsage(change);
        }
        if (type.isPoint() || type.isController()) {
            if (change == 0L) {
                return FluxTranslate.OUTPUT.get() + ": " + ChatFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.OUTPUT.get() + ": " + ChatFormatting.RED + energyType.getUsage(change);
        }
        if (type.isStorage()) {
            if (change == 0L) {
                return FluxTranslate.CHANGE.get() + ": " + ChatFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            if (change > 0L) {
                return FluxTranslate.CHANGE.get() + ": " + ChatFormatting.GREEN + "+" + energyType.getUsage(change);
            }
            return FluxTranslate.CHANGE.get() + ": " + ChatFormatting.RED + energyType.getUsage(change);
        }
        return "";
    }

    public static void writeGlobalPos(@Nonnull CompoundTag tag, @Nonnull GlobalPos pos) {
        BlockPos p = pos.m_122646_();
        tag.m_128405_("x", p.m_123341_());
        tag.m_128405_("y", p.m_123342_());
        tag.m_128405_("z", p.m_123343_());
        tag.m_128359_("dim", pos.m_122640_().m_135782_().toString());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull CompoundTag tag) {
        return GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim"))), (BlockPos)new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
    }

    public static void writeGlobalPos(@Nonnull FriendlyByteBuf buffer, @Nonnull GlobalPos pos) {
        buffer.m_130085_(pos.m_122640_().m_135782_());
        buffer.m_130064_(pos.m_122646_());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull FriendlyByteBuf buffer) {
        return GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_()), (BlockPos)buffer.m_130135_());
    }

    @Nonnull
    public static String getDisplayPos(@Nonnull GlobalPos pos) {
        BlockPos p = pos.m_122646_();
        return "X: " + p.m_123341_() + " Y: " + p.m_123342_() + " Z: " + p.m_123343_();
    }

    @Nonnull
    public static String getDisplayDim(@Nonnull GlobalPos pos) {
        return pos.m_122640_().m_135782_().toString();
    }

    public static <T> boolean addWithCheck(@Nonnull Collection<T> list, @Nullable T toAdd) {
        if (toAdd != null && !list.contains(toAdd)) {
            list.add(toAdd);
            return true;
        }
        return false;
    }

    public static int getModifiedColor(int color, float factor) {
        float h;
        int min;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int delta = max - (min = Math.min(r, Math.min(g, b)));
        if (delta == 0) {
            return Mth.m_14169_((float)0.0f, (float)0.0f, (float)Math.min(factor * (float)max / 255.0f, 1.0f));
        }
        if (max == r) {
            h = (float)(g - b) / (float)delta;
            if (h < 0.0f) {
                h += 6.0f;
            }
        } else {
            h = max == g ? 2.0f + (float)(b - r) / (float)delta : 4.0f + (float)(r - g) / (float)delta;
        }
        return Mth.m_14169_((float)(h / 6.0f), (float)Math.min(factor * (float)delta / (float)max, 1.0f), (float)Math.min(factor * (float)max / 255.0f, 1.0f));
    }

    public static String compact(long in) {
        if (in < 1000L) {
            return Long.toString(in);
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f%c", (double)in * COMPACT_SCALE[level], Character.valueOf(pre));
    }

    public static String compact(long in, String suffix) {
        if (in < 1000L) {
            return in + " " + suffix;
        }
        int level = (int)(Math.log10(in) / 3.0) - 1;
        char pre = "kMGTPE".charAt(level);
        return String.format("%.1f %c%s", (double)in * COMPACT_SCALE[level], Character.valueOf(pre), suffix);
    }

    public static boolean isBadNetworkName(@Nonnull String s) {
        return s.isEmpty() || s.length() > 24;
    }

    public static boolean isBadPassword(@Nonnull String s) {
        if (s.isEmpty() || s.length() > 16) {
            return true;
        }
        int e = s.length();
        for (int i = 0; i < e; ++i) {
            if (!FluxUtils.isBadPasswordChar(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadPasswordChar(char c) {
        return c >= '\u007f' || c <= ' ';
    }

    @Nullable
    public static <T> T get(@Nonnull ICapabilityProvider provider, @Nonnull Capability<T> cap) {
        return (T)provider.getCapability(cap).orElse(null);
    }

    @Nullable
    public static <T> T get(@Nonnull ICapabilityProvider provider, @Nonnull Capability<T> cap, Direction side) {
        return (T)provider.getCapability(cap, side).orElse(null);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }
}

