/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabStatistics
extends GuiTabCore {
    private LineChart mChart;
    private int timer = 0;

    public GuiTabStatistics(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        if (this.getNetwork().isValid()) {
            ClientMessages.updateNetwork(this.getToken(), this.getNetwork(), (byte)24);
        }
    }

    @Override
    @Nonnull
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_STATISTICS;
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        FluxNetwork network = this.getNetwork();
        if (network.isValid()) {
            int color = network.getNetworkColor();
            this.renderNetwork(poseStack, network.getNetworkName(), color, this.f_97736_ + 8);
            poseStack.m_85836_();
            poseStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
            NetworkStatistics stats = network.getStatistics();
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.PLUGS.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxPlugCount, 12.0f, 24.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.POINTS.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxPointCount, 12.0f, 36.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.STORAGES.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxStorageCount, 82.0f, 24.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.CONTROLLERS.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxControllerCount, 82.0f, 36.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.INPUT.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getUsage(stats.energyInput), 12.0f, 48.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.OUTPUT.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getUsage(stats.energyOutput), 12.0f, 60.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.BUFFER.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(stats.totalBuffer), 12.0f, 72.0f, color);
            this.f_96547_.m_92883_(poseStack, ChatFormatting.GRAY + FluxTranslate.ENERGY.get() + ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getStorage(stats.totalEnergy), 12.0f, 84.0f, color);
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            GuiTabStatistics.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(FluxTranslate.AVERAGE_TICK.get() + ": " + stats.averageTickMicro + " \u00b5s/t"), (int)((int)((float)this.f_97726_ / 2.0f * 1.3333334f)), (int)((int)(((float)this.f_97727_ - 2.0f) * 1.3333334f)), (int)color);
            poseStack.m_85849_();
        } else {
            this.renderNavigationPrompt(poseStack, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid() && this.mChart != null) {
            this.mChart.drawChart(this.getMinecraft(), poseStack, deltaTicks);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.getNetwork().isValid()) {
            this.mChart = new LineChart(this.f_96543_ / 2 - 48, this.f_96544_ / 2 + 20, 50, 6, "s", EnergyType.FE.getStorageSuffix());
            this.mChart.updateData(this.getNetwork().getStatistics().energyChange);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.getNetwork().isValid()) {
            this.timer = (this.timer + 1) % 20;
            if (this.timer == 0) {
                ClientMessages.updateNetwork(this.getToken(), this.getNetwork(), (byte)24);
            }
        }
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 8) {
            this.mChart.updateData(this.getNetwork().getStatistics().energyChange);
        }
    }

    public static class LineChart {
        private final int x;
        private final int y;
        private final int height;
        private final int linePoints;
        private final String displayUnitX;
        private String displayUnitY;
        private long maxUnitY;
        private final String suffixUnitY;
        private LongList data = new LongArrayList();
        private final FloatList currentHeight;
        private final FloatList targetHeight;

        public LineChart(int x, int y, int height, int linePoints, String displayUnitX, String suffixUnitY) {
            int i;
            this.x = x;
            this.y = y;
            this.height = height;
            this.linePoints = linePoints;
            this.displayUnitX = displayUnitX;
            this.suffixUnitY = suffixUnitY;
            this.currentHeight = new FloatArrayList(linePoints);
            for (i = 0; i < linePoints; ++i) {
                this.currentHeight.add((float)(y + height));
            }
            this.targetHeight = new FloatArrayList(linePoints);
            for (i = 0; i < linePoints; ++i) {
                this.targetHeight.add((float)(y + height));
            }
        }

        public void drawChart(Minecraft mc, PoseStack poseStack, float deltaTicks) {
            int i;
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69472_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float hw = 1.0f;
            for (i = 0; i < this.currentHeight.size() - 1; ++i) {
                float lx = this.x + 20 * i;
                float ly = this.currentHeight.getFloat(i);
                float rx = this.x + 20 * (i + 1);
                float ry = this.currentHeight.getFloat(i + 1);
                builder.m_85982_(poseStack.m_85850_().m_85861_(), rx, ry - hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), lx, ly - hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), lx, ly + hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), rx, ry + hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            }
            tesselator.m_85914_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            hw = 2.0f;
            for (i = 0; i < this.currentHeight.size(); ++i) {
                float cx = this.x + 20 * i;
                float cy = this.currentHeight.getFloat(i);
                builder.m_85982_(poseStack.m_85850_().m_85861_(), cx + hw, cy - hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), cx - hw, cy - hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), cx - hw, cy + hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                builder.m_85982_(poseStack.m_85850_().m_85861_(), cx + hw, cy + hw, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            }
            tesselator.m_85914_();
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.x - 16), (int)(this.y + this.height), (int)(this.x + 116), (int)(this.y + this.height + 1), (int)-805306369);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.x - 14), (int)(this.y - 6), (int)(this.x - 13), (int)(this.y + this.height + 3), (int)-805306369);
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            mc.f_91062_.m_92883_(poseStack, this.suffixUnitY, (float)(this.x - 15) / 0.75f - (float)mc.f_91062_.m_92895_(this.suffixUnitY), ((float)this.y - 7.5f) / 0.75f, 0xFFFFFF);
            mc.f_91062_.m_92883_(poseStack, this.displayUnitY, (float)(this.x - 15) / 0.75f - (float)mc.f_91062_.m_92895_(this.displayUnitY), (float)(this.y - 2) / 0.75f, 0xFFFFFF);
            mc.f_91062_.m_92883_(poseStack, this.displayUnitX, (float)(this.x + 118) / 0.75f - (float)mc.f_91062_.m_92895_(this.displayUnitX), ((float)(this.y + this.height) + 1.5f) / 0.75f, 0xFFFFFF);
            for (i = 0; i < this.data.size(); ++i) {
                String d = FluxUtils.compact(this.data.getLong(i));
                mc.f_91062_.m_92883_(poseStack, d, (float)(this.x + 20 * i) / 0.75f - (float)mc.f_91062_.m_92895_(d) * 0.5f, (this.currentHeight.getFloat(i) - 8.0f) / 0.75f, 0xFFFFFF);
                String c = String.valueOf((5 - i) * 5);
                mc.f_91062_.m_92883_(poseStack, c, (float)(this.x + 20 * i) / 0.75f - (float)mc.f_91062_.m_92895_(c) * 0.5f, (float)(this.y + this.height + 2) / 0.75f, 0xFFFFFF);
            }
            poseStack.m_85849_();
            this.updateHeight(deltaTicks);
        }

        public void updateData(LongList newData) {
            this.data = newData;
            this.calculateUnitY((List<Long>)newData);
            this.calculateTargetHeight((List<Long>)newData);
        }

        private void updateHeight(float deltaTicks) {
            if (this.currentHeight.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.currentHeight.size(); ++i) {
                float diff = this.targetHeight.getFloat(i) - this.currentHeight.getFloat(i);
                if (diff == 0.0f) continue;
                float p = deltaTicks / 16.0f;
                float r = Math.abs(diff) <= p ? this.targetHeight.getFloat(i) : (diff > 0.0f ? this.currentHeight.getFloat(i) + Math.max(Math.min(diff, diff / 4.0f * deltaTicks), p) : this.currentHeight.getFloat(i) + Math.min(Math.max(diff, diff / 4.0f * deltaTicks), -p));
                this.currentHeight.set(i, r);
            }
        }

        private void calculateUnitY(@Nonnull List<Long> data) {
            long maxUnitY;
            long maxValue = 0L;
            for (long v : data) {
                maxValue = Math.max(maxValue, v);
            }
            if (maxValue <= 0L) {
                this.displayUnitY = "1";
                this.maxUnitY = 1L;
                return;
            }
            int exp = (int)Math.log10(maxValue);
            if (exp <= 0) {
                maxUnitY = maxValue + 1L;
            } else if (exp <= 1) {
                maxUnitY = (maxValue / 5L + 1L) * 5L;
            } else if (exp <= 2) {
                maxUnitY = (maxValue / 50L + 1L) * 50L;
            } else {
                int unit = 10;
                for (int i = 1; i < exp; ++i) {
                    unit *= 10;
                }
                maxUnitY = (maxValue / (long)unit + 1L) * (long)unit;
            }
            this.displayUnitY = FluxUtils.compact(maxUnitY);
            this.maxUnitY = maxUnitY;
        }

        private void calculateTargetHeight(@Nonnull List<Long> data) {
            if (data.size() != this.linePoints) {
                return;
            }
            int i = 0;
            for (Long value : data) {
                this.targetHeight.set(i, (float)((double)this.y + (double)this.height * (1.0 - (double)value.longValue() / (double)this.maxUnitY)));
                ++i;
            }
        }
    }
}

