/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.EditButton;
import sonar.fluxnetworks.client.gui.popup.PopupNetworkPassword;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.util.FluxUtils;

public class GuiTabSelection
extends GuiTabPages<FluxNetwork> {
    private EditButton mDisconnect;
    public FluxNetwork mSelectedNetwork;

    public GuiTabSelection(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 13;
        this.mGridPerPage = 9;
        this.mElementWidth = 146;
        this.mElementHeight = 12;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SELECTION;
    }

    @Override
    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        if (this.mElements.isEmpty()) {
            this.renderNavigationPrompt(poseStack, FluxTranslate.ERROR_NO_NETWORK, EnumNavigationTab.TAB_CREATE);
        } else {
            String total = FluxTranslate.TOTAL.get() + ": " + this.mElements.size();
            this.f_96547_.m_92883_(poseStack, total, (float)(this.f_97735_ + 158 - this.f_96547_.m_92895_(total)), (float)(this.f_97736_ + 24), 0xFFFFFF);
            String sortBy = FluxTranslate.SORT_BY.get() + ": " + ChatFormatting.AQUA + this.mSortType.getTranslatedName();
            this.f_96547_.m_92883_(poseStack, sortBy, (float)(this.f_97735_ + 19), (float)(this.f_97736_ + 24), 0xFFFFFF);
            this.renderNetwork(poseStack, this.getNetwork().getNetworkName(), this.getNetwork().getNetworkColor(), this.f_97736_ + 8);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mGridStartX = this.f_97735_ + 15;
        this.mGridStartY = this.f_97736_ + 36;
        this.refreshPages(ClientCache.getAllNetworks());
        if (!this.mElements.isEmpty()) {
            this.mDisconnect = new EditButton(this, this.f_97735_ + 142, this.f_97736_ + 10, 8, 8, 0, 0, FluxTranslate.BATCH_DISCONNECT_BUTTON.get(), FluxTranslate.BATCH_DISCONNECT_BUTTON.get());
            this.mDisconnect.setClickable(this.getNetwork().isValid());
            this.mButtons.add(this.mDisconnect);
        }
    }

    @Override
    public void renderElement(PoseStack poseStack, FluxNetwork element, int x, int y) {
        boolean locked;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON);
        boolean selected = this.getNetwork() == element;
        boolean bl = locked = element.getSecurityLevel() != SecurityLevel.PUBLIC;
        if (locked) {
            if (selected) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            this.blitF(poseStack, x + 133, y + 1, 10.0f, 10.0f, 384.0f, 256.0f, 64.0f, 64.0f);
        }
        int color = element.getNetworkColor();
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        if (selected) {
            GuiTabSelection.m_93172_((PoseStack)poseStack, (int)(x - 2), (int)y, (int)(x - 1), (int)(y + this.mElementHeight), (int)-1);
            GuiTabSelection.m_93172_((PoseStack)poseStack, (int)(x + this.mElementWidth + 1), (int)y, (int)(x + this.mElementWidth + 2), (int)(y + this.mElementHeight), (int)-1);
        }
        this.renderBarAndName(poseStack, element, x, y, selected);
    }

    protected void renderBarAndName(PoseStack poseStack, FluxNetwork element, int x, int y, boolean selected) {
        this.blitF(poseStack, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 352.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        this.f_96547_.m_92883_(poseStack, element.getNetworkName(), (float)(x + 4), (float)(y + 2), selected ? 0xFFFFFF : 0x606060);
    }

    @Override
    public void renderElementTooltip(PoseStack poseStack, FluxNetwork element, int mouseX, int mouseY) {
        this.m_96597_(poseStack, this.getElementTooltips(element), mouseX, mouseY);
    }

    protected List<Component> getElementTooltips(@Nonnull FluxNetwork element) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.m_237113_((String)("ID: " + element.getNetworkID())));
        components.add((Component)FluxTranslate.NETWORK_NAME.makeComponent().m_130946_(": " + ChatFormatting.AQUA + element.getNetworkName()));
        components.add((Component)FluxTranslate.NETWORK_SECURITY.makeComponent().m_130946_(": " + ChatFormatting.GOLD + element.getSecurityLevel().getName()));
        AccessLevel access = element.getPlayerAccess(this.mPlayer);
        if (access != AccessLevel.BLOCKED) {
            components.add((Component)FluxTranslate.ACCESS.makeComponent().m_130946_(": " + access.getFormattedName()));
        }
        if (ClientCache.sWirelessNetwork == element.getNetworkID()) {
            components.add((Component)FluxTranslate.EFFECTIVE_WIRELESS_NETWORK.makeComponent().m_130940_(ChatFormatting.YELLOW));
        }
        return components;
    }

    @Override
    protected void onElementClicked(FluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.mSelectedNetwork = element;
            this.setConnectedNetwork(element, ClientCache.getRecentPassword(element.getNetworkID()));
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            if (mouseX >= (double)(this.f_97735_ + 45) && mouseX < (double)(this.f_97735_ + 75) && mouseY >= (double)(this.f_97736_ + 24) && mouseY < (double)(this.f_97736_ + 32)) {
                this.mSortType = (GuiTabPages.SortType)FluxUtils.cycle((Enum)this.mSortType, (Enum[])GuiTabPages.SortType.values());
                this.sortGrids(this.mSortType);
                this.refreshCurrentPage();
                return true;
            }
            if (this.mElements.isEmpty()) {
                return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_CREATE);
            }
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button == this.mDisconnect) {
            this.setConnectedNetwork(FluxNetwork.INVALID, "");
        }
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 4) {
            if (code == -2) {
                this.openPopup(new PopupNetworkPassword(this));
            } else if (code == -1) {
                if (this.mSelectedNetwork != null) {
                    Object p;
                    Object object = this.getCurrentPopup();
                    if (object instanceof PopupNetworkPassword) {
                        p = (PopupNetworkPassword)((Object)object);
                        ClientCache.updateRecentPassword(this.mSelectedNetwork.getNetworkID(), p.mPassword.m_94155_());
                    }
                    if ((object = ((FluxMenu)this.f_97732_).mProvider) instanceof ItemFluxConfigurator.Provider) {
                        p = (ItemFluxConfigurator.Provider)object;
                        CompoundTag tag = ((ItemFluxConfigurator.Provider)p).mStack.m_41698_("FluxData");
                        tag.m_128405_("networkID", this.mSelectedNetwork.getNetworkID());
                    }
                }
                this.closePopup();
                this.mSelectedNetwork = null;
            }
        } else if (key == 8) {
            this.refreshPages(ClientCache.getAllNetworks());
        }
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.mDisconnect != null) {
            this.mDisconnect.setClickable(this.getNetwork().isValid());
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.mElements.sort(Comparator.comparing(FluxNetwork::getNetworkID));
                break;
            }
            case NAME: {
                this.mElements.sort(Comparator.comparing(FluxNetwork::getNetworkName));
            }
        }
    }
}

