/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data;

import de.melanx.extradisks.items.Registration;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageType;
import de.melanx.extradisks.items.item.ExtraItemStorageType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModTags {

    public static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(DataGenerator generator, ExistingFileHelper helper, BlockTagsProvider provider) {
            super(generator, provider, "extradisks", helper);
        }

        protected void m_6577_() {
            TagsProvider.TagAppender itemPartsBuilder = this.m_206424_(Items.ITEM_PARTS);
            TagsProvider.TagAppender itemDisksBuilder = this.m_206424_(Items.ITEM_DISKS);
            for (ExtraItemStorageType type : ExtraItemStorageType.values()) {
                TagKey<Item> tag = Items.PARTS_ITEM.get((Object)type);
                this.m_206424_(tag).m_126582_((Object)((Item)Registration.ITEM_STORAGE_PART.get((Object)type).get()));
                itemPartsBuilder.m_206428_(tag);
                tag = Items.DISKS_ITEM.get((Object)type);
                this.m_206424_(tag).m_126582_((Object)((Item)Registration.ITEM_STORAGE_DISK.get((Object)type).get()));
                itemDisksBuilder.m_206428_(tag);
            }
            TagsProvider.TagAppender fluidPartsBuilder = this.m_206424_(Items.FLUID_PARTS);
            TagsProvider.TagAppender fluidDisksBuilder = this.m_206424_(Items.FLUID_DISKS);
            for (ExtraFluidStorageType extraFluidStorageType : ExtraFluidStorageType.values()) {
                TagKey<Item> tag = Items.PARTS_FLUID.get((Object)extraFluidStorageType);
                this.m_206424_(tag).m_126582_((Object)((Item)Registration.FLUID_STORAGE_PART.get((Object)extraFluidStorageType).get()));
                fluidPartsBuilder.m_206428_(tag);
                tag = Items.DISKS_FLUID.get((Object)extraFluidStorageType);
                this.m_206424_(tag).m_126582_((Object)((Item)Registration.FLUID_STORAGE_DISK.get((Object)extraFluidStorageType).get()));
                fluidDisksBuilder.m_206428_(tag);
            }
            this.m_206424_(Items.PARTS).addTags(new TagKey[]{Items.ITEM_PARTS, Items.FLUID_PARTS});
            this.m_206424_(Items.DISKS).addTags(new TagKey[]{Items.ITEM_DISKS, Items.FLUID_DISKS});
            this.m_206421_(Blocks.ITEM_STORAGE_BLOCKS, Items.ITEM_STORAGE_BLOCKS);
            for (Enum enum_ : ExtraItemStorageType.values()) {
                this.m_206421_(Blocks.STORAGE_BLOCKS_ITEM.get(enum_), Items.STORAGE_BLOCKS_ITEM.get(enum_));
            }
            this.m_206421_(Blocks.FLUID_STORAGE_BLOCKS, Items.FLUID_STORAGE_BLOCKS);
            for (Enum enum_ : ExtraFluidStorageType.values()) {
                this.m_206421_(Blocks.STORAGE_BLOCKS_FLUID.get(enum_), Items.STORAGE_BLOCKS_FLUID.get(enum_));
            }
            this.m_206421_(Blocks.STORAGE_BLOCKS, Items.STORAGE_BLOCKS);
        }
    }

    public static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(DataGenerator generator, ExistingFileHelper helper) {
            super(generator, "extradisks", helper);
        }

        protected void m_6577_() {
            TagsProvider.TagAppender itemBlocksBuilder = this.m_206424_(Blocks.ITEM_STORAGE_BLOCKS);
            for (ExtraItemStorageType type : ExtraItemStorageType.values()) {
                TagKey<Block> tag = Blocks.STORAGE_BLOCKS_ITEM.get((Object)type);
                this.m_206424_(tag).m_126582_((Object)((Block)Registration.ITEM_STORAGE_BLOCK.get((Object)type).get()));
                itemBlocksBuilder.m_206428_(tag);
            }
            TagsProvider.TagAppender fluidBlocksBuilder = this.m_206424_(Blocks.FLUID_STORAGE_BLOCKS);
            for (ExtraFluidStorageType type : ExtraFluidStorageType.values()) {
                TagKey<Block> tag = Blocks.STORAGE_BLOCKS_FLUID.get((Object)type);
                this.m_206424_(tag).m_126582_((Object)((Block)Registration.FLUID_STORAGE_BLOCK.get((Object)type).get()));
                fluidBlocksBuilder.m_206428_(tag);
            }
            this.m_206424_(Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{Blocks.ITEM_STORAGE_BLOCKS, Blocks.FLUID_STORAGE_BLOCKS});
        }
    }

    public static class Items {
        public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final TagKey<Item> ITEM_STORAGE_BLOCKS = Items.tag("storage_blocks/items");
        public static final TagKey<Item> FLUID_STORAGE_BLOCKS = Items.tag("storage_blocks/fluids");
        public static final Map<ExtraItemStorageType, TagKey<Item>> STORAGE_BLOCKS_ITEM = new HashMap<ExtraItemStorageType, TagKey<Item>>();
        public static final Map<ExtraFluidStorageType, TagKey<Item>> STORAGE_BLOCKS_FLUID = new HashMap<ExtraFluidStorageType, TagKey<Item>>();
        public static final TagKey<Item> PARTS = Items.tag("parts");
        public static final TagKey<Item> ITEM_PARTS = Items.tag("parts/items");
        public static final TagKey<Item> FLUID_PARTS = Items.tag("parts/fluids");
        public static final Map<ExtraItemStorageType, TagKey<Item>> PARTS_ITEM = new HashMap<ExtraItemStorageType, TagKey<Item>>();
        public static final Map<ExtraFluidStorageType, TagKey<Item>> PARTS_FLUID = new HashMap<ExtraFluidStorageType, TagKey<Item>>();
        public static final TagKey<Item> DISKS = Items.tag("disks");
        public static final TagKey<Item> ITEM_DISKS = Items.tag("disks/items");
        public static final TagKey<Item> FLUID_DISKS = Items.tag("disks/fluids");
        public static final Map<ExtraItemStorageType, TagKey<Item>> DISKS_ITEM = new HashMap<ExtraItemStorageType, TagKey<Item>>();
        public static final Map<ExtraFluidStorageType, TagKey<Item>> DISKS_FLUID = new HashMap<ExtraFluidStorageType, TagKey<Item>>();

        private static TagKey<Item> tag(String name) {
            return net.minecraft.tags.ItemTags.create((ResourceLocation)new ResourceLocation("refinedstorage", name));
        }

        static {
            for (ExtraItemStorageType extraItemStorageType : ExtraItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(extraItemStorageType, Items.tag("storage_blocks/items/" + extraItemStorageType.getName()));
                PARTS_ITEM.put(extraItemStorageType, Items.tag("parts/items/" + extraItemStorageType.getName()));
                DISKS_ITEM.put(extraItemStorageType, Items.tag("disks/items/" + extraItemStorageType.getName()));
            }
            for (Enum enum_ : ExtraFluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((ExtraFluidStorageType)enum_, Items.tag("storage_blocks/fluids/" + ((ExtraFluidStorageType)enum_).getName()));
                PARTS_FLUID.put((ExtraFluidStorageType)enum_, Items.tag("parts/fluids/" + ((ExtraFluidStorageType)enum_).getName()));
                DISKS_FLUID.put((ExtraFluidStorageType)enum_, Items.tag("disks/fluids/" + ((ExtraFluidStorageType)enum_).getName()));
            }
        }
    }

    public static class Blocks {
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.tag("storage_blocks");
        public static final TagKey<Block> ITEM_STORAGE_BLOCKS = Blocks.tag("storage_blocks/items");
        public static final TagKey<Block> FLUID_STORAGE_BLOCKS = Blocks.tag("storage_blocks/fluids");
        public static final Map<ExtraItemStorageType, TagKey<Block>> STORAGE_BLOCKS_ITEM = new HashMap<ExtraItemStorageType, TagKey<Block>>();
        public static final Map<ExtraFluidStorageType, TagKey<Block>> STORAGE_BLOCKS_FLUID = new HashMap<ExtraFluidStorageType, TagKey<Block>>();

        private static TagKey<Block> tag(String name) {
            return net.minecraft.tags.BlockTags.create((ResourceLocation)new ResourceLocation("refinedstorage", name));
        }

        static {
            for (ExtraItemStorageType extraItemStorageType : ExtraItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(extraItemStorageType, Blocks.tag("storage_blocks/items/" + extraItemStorageType.getName()));
            }
            for (Enum enum_ : ExtraFluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((ExtraFluidStorageType)enum_, Blocks.tag("storage_blocks/fluids/" + ((ExtraFluidStorageType)enum_).getName()));
            }
        }
    }
}

