/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.client.particle.ParticleFartData;

public class FartPacket
extends PlayerPositionPacket {
    private static final int MAX_PARTICLES = 200;
    private static final int MIN_PARTICLES = 100;
    private static final float CLIENT_PLAYER_Y_OFFSET = -0.8f;
    private static final float REMOTE_PLAYER_Y_OFFSET = 0.65f;
    private static final List<UUID> ALLOW_RAINBOW_FARTS = new ArrayList<UUID>();

    public FartPacket() {
    }

    public FartPacket(Player player) {
        super(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (GeneralConfig.farting) {
            super.actionClient(world, player);
        }
    }

    protected void performClientAction(Level world, Player player) {
        this.spawnFartParticles(world, player, this.position, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFartParticles(Level world, Player player, Vec3 pos, boolean isClientSidePlayer) {
        if (player == null) {
            return;
        }
        RandomSource rand = world.f_46441_;
        int numParticles = rand.m_188503_(100) + 100;
        boolean rainbow = this.hasRainbowFart(player);
        double yaw = (double)player.m_146908_() * Math.PI / 180.0;
        double playerXOffset = Math.sin(yaw) * 0.7;
        double playerZOffset = -Math.cos(yaw) * 0.7;
        float playerYOffset = isClientSidePlayer ? 0.65f : -0.8f;
        for (int i = 0; i < numParticles; ++i) {
            double extraDistance = (double)rand.m_188501_() % 0.3;
            double particleX = pos.f_82479_ + playerXOffset + extraDistance;
            double particleY = pos.f_82480_ + (double)playerYOffset;
            double particleZ = pos.f_82481_ + playerZOffset + extraDistance;
            float particleMotionX = -0.5f + rand.m_188501_();
            float particleMotionY = -0.5f + rand.m_188501_();
            float particleMotionZ = -0.5f + rand.m_188501_();
            world.m_7106_((ParticleOptions)new ParticleFartData(rainbow), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public boolean hasRainbowFart(Player player) {
        return player.m_36316_() != null && ALLOW_RAINBOW_FARTS.contains(player.m_36316_().getId());
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (GeneralConfig.farting) {
            Advancements.FART.test(player);
            super.actionServer(world, player);
        }
    }

    protected PlayerPositionPacket create(Player player, int range) {
        return new FartPacket(player);
    }

    protected ModBase getModInstance() {
        return EvilCraft._instance;
    }

    static {
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("068d4de0-3a75-4c6a-9f01-8c37e16a394c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("777e7aa3-9373-4511-8d75-f99d23ebe252"));
    }
}

