/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityItemUndespawnable;
import org.cyclops.evilcraft.item.ItemKineticatorConfig;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public class ItemKineticator
extends ItemBloodContainer {
    private static final int POWER_LEVELS = 5;
    private static final int RANGE_PER_LEVEL = 2;
    private static final double USAGE_PER_D = 0.1;
    private static final int CONTAINER_SIZE = 1000;
    private final boolean repelling;

    public ItemKineticator(Item.Properties properties, boolean repelling) {
        super(properties, 1000);
        this.repelling = repelling;
    }

    public boolean isRepelling(ItemStack itemStack) {
        return this.repelling;
    }

    private int getArea(ItemStack itemStack) {
        return 2 * (this.getPower(itemStack) + 1);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, 5, false) && !world.m_5776_()) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.m_5524_() + ".info.attraction"));
        list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".info.area"), (Object[])new Object[]{this.getArea(itemStack)}).m_130940_(ChatFormatting.BOLD));
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }

    public void setPower(ItemStack itemStack, int power) {
        ItemPowerableHelpers.setPower(itemStack, power);
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity instanceof Player) {
            this.kineticate(itemStack, world, entity);
        }
        super.m_6883_(itemStack, world, entity, par4, par5);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        this.kineticate(itemStack, entityItem.f_19853_, (Entity)entityItem);
        return super.onEntityItemUpdate(itemStack, entityItem);
    }

    private void kineticate(ItemStack itemStack, Level world, Entity entity) {
        if (ItemHelpers.isActivated(itemStack) && (FluidUtil.getFluidContained((ItemStack)itemStack) != null || entity instanceof Player && this.canConsume(1, itemStack, (Player)entity)) && entity != null && !entity.m_6047_()) {
            IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            boolean repelling = this.isRepelling(itemStack);
            boolean isPlayer = entity instanceof Player;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            if (0L == world.m_46467_() % (long)ItemKineticatorConfig.tickHoldoff) {
                int area = this.getArea(itemStack);
                AABB box = new AABB(x, y, z, x, y, z).m_82400_((double)area);
                List entities = world.m_6249_(entity, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                    public boolean apply(Entity entity) {
                        return entity instanceof ItemEntity || ItemKineticatorConfig.moveXP && entity instanceof ExperienceOrb;
                    }
                });
                for (Entity moveEntity : entities) {
                    if (!repelling && (!(moveEntity instanceof ItemEntity) || ((ItemEntity)moveEntity).m_32063_() || !this.canKineticateItem(((ItemEntity)moveEntity).m_32055_())) && !(moveEntity instanceof ExperienceOrb)) continue;
                    double dx = moveEntity.m_20185_() - x;
                    double dy = moveEntity.m_20186_() - (isPlayer ? y + (double)(world.m_5776_() ? -1 : 1) : y);
                    double dz = moveEntity.m_20189_() - z;
                    double strength = -0.3;
                    if (isPlayer) {
                        strength = -1.0;
                    }
                    if (repelling) {
                        strength /= -1.0;
                        if (isPlayer) {
                            strength = 0.3;
                        }
                    }
                    double d = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
                    int usage = (int)Math.round(d * 0.1);
                    if (!repelling && !(d > 0.5) || usage != 0 && fluidHandler.drain(usage, IFluidHandler.FluidAction.SIMULATE) == null && (!isPlayer || !this.canConsume(usage, itemStack, (Player)entity))) continue;
                    double m = 1.0 / (2.0 * Math.max(1.0, d));
                    dx *= m;
                    dy *= m;
                    dz *= m;
                    if (world.m_5776_()) {
                        this.showEntityMoved(world, entity, moveEntity, dx / 10.0, dy / 10.0, dz / 10.0);
                    } else {
                        if (moveEntity instanceof ItemEntity && d < 5.0) {
                            ((ItemEntity)moveEntity).m_32010_(repelling ? 5 : 0);
                        }
                        moveEntity.m_20256_(new Vec3(dx, dy, dz).m_82542_(strength, strength, strength));
                        if (moveEntity.f_19862_) {
                            moveEntity.m_20256_(new Vec3(moveEntity.m_20184_().f_82479_, 0.3, moveEntity.m_20184_().f_82481_));
                        }
                    }
                    if (0L != world.m_46467_() % (long)ItemKineticatorConfig.consumeHoldoff) continue;
                    if (isPlayer) {
                        this.consume(usage, itemStack, (Player)entity);
                        continue;
                    }
                    fluidHandler.drain(usage, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    protected boolean canKineticateItem(ItemStack entityItem) {
        if (entityItem == null) {
            return false;
        }
        return !ItemKineticatorConfig.kineticateBlacklist.contains(ForgeRegistries.ITEMS.getKey((Object)entityItem.m_41720_()).toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showEntityMoved(Level world, Entity player, Entity entity, double dx, double dy, double dz) {
        RandomSource rand = world.f_46441_;
        float scale = 0.05f;
        float red = rand.m_188501_() * 0.03f + 0.5f;
        float green = rand.m_188501_() * 0.03f + (rand.m_188499_() ? 0.5f : 0.3f);
        float blue = rand.m_188501_() * 0.05f;
        float ageMultiplier = (float)(rand.m_188500_() * 2.5 + 10.0);
        world.m_6493_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), -dx, -dy, -dz);
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemStack) {
        return new EntityItemUndespawnable(world, (ItemEntity)location);
    }
}

