/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class RecipeEnvironmentalAccumulator
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final WeatherType inputWeather;
    private final Either<ItemStack, ItemStackFromIngredient> outputItem;
    private final WeatherType outputWeather;
    private final int duration;
    private final int cooldownTime;
    private final float processingSpeed;

    public RecipeEnvironmentalAccumulator(ResourceLocation id, Ingredient inputIngredient, WeatherType inputWeather, Either<ItemStack, ItemStackFromIngredient> outputItem, WeatherType outputWeather, int duration, int cooldownTime, float processingSpeed) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputWeather = inputWeather;
        this.outputItem = outputItem;
        this.outputWeather = outputWeather;
        this.duration = duration;
        this.cooldownTime = cooldownTime;
        this.processingSpeed = processingSpeed;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public WeatherType getInputWeather() {
        return this.inputWeather;
    }

    public Either<ItemStack, ItemStackFromIngredient> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public WeatherType getOutputWeather() {
        return this.outputWeather;
    }

    public int getDuration() {
        if (this.duration < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.duration;
    }

    public int getCooldownTime() {
        if (this.cooldownTime < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return this.cooldownTime;
    }

    public float getProcessingSpeed() {
        if (this.processingSpeed < 0.0f) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.processingSpeed;
    }

    public boolean matches(Inventory inv, Level worldIn) {
        return this.inputIngredient.test(inv.m_8020_(0)) && this.inputWeather.isActive(worldIn);
    }

    public ItemStack assemble(Inventory inv) {
        ItemStack inputStack = inv.m_8020_(0);
        ItemStack itemStack = this.m_8043_().m_41777_();
        if (!inputStack.m_41619_() && inputStack.m_41782_()) {
            if (!itemStack.m_41782_()) {
                itemStack.m_41751_(new CompoundTag());
            }
            for (String key : inputStack.m_41783_().m_128431_()) {
                if (itemStack.m_41783_().m_128441_(key)) continue;
                itemStack.m_41783_().m_128365_(key, inputStack.m_41783_().m_128423_(key));
            }
        }
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack m_8043_() {
        return this.getOutputItemFirst().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_ENVIRONMENTAL_ACCUMULATOR;
    }

    public RecipeType<?> m_6671_() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    public static interface Inventory
    extends Container {
        public Level getWorld();

        public BlockPos getPos();
    }

    public static class InventoryDummy
    extends SimpleContainer
    implements Inventory {
        public InventoryDummy(ItemStack ... stacksIn) {
            super(stacksIn);
        }

        @Override
        public Level getWorld() {
            return null;
        }

        @Override
        public BlockPos getPos() {
            return null;
        }
    }
}

