/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.spiritfurnace;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.item.WeightedItemStack;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockSpiritFurnaceConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.helper.MathHelpers;

public class BoxCookTickAction
implements ITickAction<BlockEntitySpiritFurnace> {
    public static final Map<Class<? extends LivingEntity>, List<WeightedItemStack>> MOBDROP_OVERRIDES = Maps.newHashMap();
    public static final Map<UUID, List<WeightedItemStack>> PLAYERDROP_OVERRIDES_INNER = Maps.newHashMap();
    public static final ItemStack[] PLAYERDROP_RANDOM;

    public static void overrideMobDrop(Class<? extends LivingEntity> entity, Set<WeightedItemStack> drops) {
        MOBDROP_OVERRIDES.put(entity, WeightedItemStack.createWeightedList(drops));
    }

    public static void overridePlayerDropInner(String playerId, ItemStack drop) {
        PLAYERDROP_OVERRIDES_INNER.put(UUID.fromString(playerId), WeightedItemStack.createWeightedList((Set)Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(drop, 1)})));
    }

    @Override
    public boolean canTick(BlockEntitySpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.isForceHalt() && !tile.isCaughtError() && tile.canWork() && tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, 0) && !this.getCookStack(tile).m_41619_() && tile.getTileWorkingMetadata().canConsume(this.getCookStack(tile), tile.m_58904_())) {
            for (int slotId : tile.getProduceSlots()) {
                ItemStack production = tile.getInventory().m_8020_(slotId);
                if (production != null && production.m_41613_() >= production.m_41741_()) continue;
                return tile.isSizeValidForEntity();
            }
        }
        return false;
    }

    protected ItemStack getCookStack(BlockEntitySpiritFurnace tile) {
        return tile.getInventory().m_8020_(tile.getConsumeSlot());
    }

    protected ItemStack getPlayerSkull(String playerName) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42680_);
        itemStack.m_41751_(new CompoundTag());
        itemStack.m_41783_().m_128359_("SkullOwner", playerName);
        return itemStack;
    }

    protected ItemStack getPlayerDeterminedDrop(String playerId) {
        return PLAYERDROP_RANDOM[Math.abs(playerId.hashCode() % PLAYERDROP_RANDOM.length)].m_41777_();
    }

    protected void doNextDrop(BlockEntitySpiritFurnace tile) {
        Entity entityRaw = tile.getEntity();
        if (entityRaw instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityRaw;
            Level world = tile.m_58904_();
            SoundEvent deathSound = entity.m_5592_();
            if (BlockSpiritFurnaceConfig.mobDeathSounds && deathSound != null) {
                BlockPos pos = tile.m_58899_();
                world.m_5594_(null, pos, deathSound, entity.m_5720_(), 0.5f + world.f_46441_.m_188501_() * 0.2f, 1.0f);
            }
            if (tile.isPlayer()) {
                WeightedItemStack weightedItemStack;
                ItemStack drop;
                UUID playerUuid = UUID.fromString(tile.getPlayerId());
                LinkedList possibleDrops = Lists.newLinkedList();
                possibleDrops.add(new WeightedItemStack(this.getPlayerDeterminedDrop(tile.getPlayerId()), 1));
                List<WeightedItemStack> overridenDrops = PLAYERDROP_OVERRIDES_INNER.get(playerUuid);
                if (overridenDrops == null) {
                    Map<String, List<WeightedItemStack>> playerDropOverrides = this.getPlayerDropOverrides();
                    overridenDrops = playerDropOverrides.get(playerUuid.toString());
                }
                if (overridenDrops != null) {
                    possibleDrops.addAll(overridenDrops);
                }
                if (!"Forgotten Player".equals(tile.getPlayerName())) {
                    possibleDrops.add(new WeightedItemStack(this.getPlayerSkull(tile.getPlayerName()), 1));
                }
                if (!(drop = (weightedItemStack = WeightedItemStack.getRandomWeightedItemStack((List)possibleDrops, (RandomSource)world.f_46441_)).getItemStackWithRandomizedSize(world.f_46441_)).m_41619_()) {
                    tile.onItemDrop(drop);
                }
            } else if (MOBDROP_OVERRIDES.containsKey(entity.getClass())) {
                List<WeightedItemStack> possibleDrops = MOBDROP_OVERRIDES.get(entity.getClass());
                WeightedItemStack weightedItemStack = WeightedItemStack.getRandomWeightedItemStack(possibleDrops, (RandomSource)world.f_46441_);
                ItemStack drop = weightedItemStack.getItemStackWithRandomizedSize(world.f_46441_);
                if (!drop.m_41619_()) {
                    tile.onItemDrop(drop);
                }
            } else {
                Map<EntityType<?>, ResourceLocation> mobDropTablesOverrides = this.getMobDropTablesOverrides();
                ResourceLocation deathLootTable = mobDropTablesOverrides.containsKey(entity.m_6095_()) ? mobDropTablesOverrides.get(entity.m_6095_()) : entity.m_5743_();
                if (deathLootTable != null) {
                    LootTable loottable = ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(deathLootTable);
                    FakePlayer killerEntity = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)tile.m_58904_()));
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)tile.m_58904_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_())).m_78972_(LootContextParams.f_81458_, (Object)killerEntity).m_78972_(LootContextParams.f_81459_, (Object)killerEntity).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.f_19318_);
                    for (ItemStack itemstack : loottable.m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81415_))) {
                        tile.onItemDrop(itemstack);
                    }
                }
            }
        }
    }

    private Map<String, List<WeightedItemStack>> getPlayerDropOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.playerDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace player drop config.");
            }
            try {
                String playerId = split[0];
                boolean validId = true;
                try {
                    UUID.fromString(playerId);
                }
                catch (IllegalArgumentException e) {
                    validId = false;
                }
                if (!validId) {
                    EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " does not refer to a valid player UUID; skipping.");
                    continue;
                }
                try {
                    ItemStack itemStack = ItemStackHelpers.parseItemStack((String)split[1]);
                    map.put(playerId, Lists.newArrayList((Object[])new WeightedItemStack[]{new WeightedItemStack(itemStack, 1)}));
                }
                catch (IllegalArgumentException e) {
                    EvilCraft.clog("Invalid item '" + split[1] + "' in a Spirit Furnace player drop config; skipping:" + e.getMessage(), org.apache.logging.log4j.Level.ERROR);
                }
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " is not a number; skipping.");
            }
        }
        return map;
    }

    private Map<EntityType<?>, ResourceLocation> getMobDropTablesOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.mobDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace mob drop config.");
            }
            ResourceLocation entityName = new ResourceLocation(split[0]);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entityName)) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace mob drop config: " + split[0] + " does not refer to a valid entity name; skipping.");
                continue;
            }
            ResourceLocation resourceLocation = new ResourceLocation(split[1]);
            map.put((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityName), resourceLocation);
        }
        return map;
    }

    protected int getRequiredMb(BlockEntitySpiritFurnace tile, int tick) {
        int baseUsage = tile.isPlayer() ? BlockSpiritFurnaceConfig.playerMBPerTick : (tile.getEntity() != null && !tile.getEntity().m_6072_() ? BlockSpiritFurnaceConfig.bossMBPerTick : BlockSpiritFurnaceConfig.mBPerTick);
        MutableDouble drain = new MutableDouble((double)baseUsage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, BlockEntitySpiritFurnace.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public void onTick(BlockEntitySpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), IFluidHandler.FluidAction.EXECUTE);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            this.doNextDrop(tile);
        }
    }

    @Override
    public float getRequiredTicks(BlockEntitySpiritFurnace tile, int slot, int tick) {
        int requiredTicksBase;
        Entity entity = tile.getEntity();
        if (entity == null) {
            requiredTicksBase = BlockSpiritFurnaceConfig.requiredTicksPerHp;
        } else {
            try {
                LivingEntity livingEntity = (LivingEntity)entity;
                requiredTicksBase = (int)((livingEntity.m_21223_() + (float)livingEntity.m_21230_()) * (float)BlockSpiritFurnaceConfig.requiredTicksPerHp);
            }
            catch (RuntimeException e) {
                requiredTicksBase = 40 * BlockSpiritFurnaceConfig.requiredTicksPerHp;
            }
        }
        MutableDouble duration = new MutableDouble((double)requiredTicksBase);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(duration, BlockEntitySpiritFurnace.UPGRADEEVENT_SPEED));
        return (int)duration.getValue().doubleValue();
    }

    static {
        if (BlockSpiritFurnaceConfig.villagerDropEmeraldChance > 0) {
            BoxCookTickAction.overrideMobDrop(Villager.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((ItemLike)Items.f_42616_), 1), new WeightedItemStack(ItemStack.f_41583_, BlockSpiritFurnaceConfig.villagerDropEmeraldChance - 1)}));
        }
        BoxCookTickAction.overrideMobDrop(WitherBoss.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((ItemLike)Items.f_42686_), 1)}));
        BoxCookTickAction.overridePlayerDropInner("068d4de0-3a75-4c6a-9f01-8c37e16a394c", new ItemStack((ItemLike)Items.f_42616_));
        BoxCookTickAction.overridePlayerDropInner("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c", new ItemStack((ItemLike)Items.f_42420_));
        BoxCookTickAction.overridePlayerDropInner("777e7aa3-9373-4511-8d75-f99d23ebe252", new ItemStack((ItemLike)Items.f_42495_).m_41714_((Component)Component.m_237113_((String)"Lekkere Stront")));
        BoxCookTickAction.overridePlayerDropInner("3e13f558-fb72-4949-a842-07879924bc49", new ItemStack((ItemLike)Items.f_42692_));
        BoxCookTickAction.overridePlayerDropInner("b5c31e33-8224-4f96-a4bf-73721be9d2ec", new ItemStack((ItemLike)Blocks.f_50652_));
        BoxCookTickAction.overridePlayerDropInner("b2faeaab-fc87-4f91-98d3-836024f268ae", new ItemStack((ItemLike)Blocks.f_50094_).m_41714_((Component)Component.m_237113_((String)"Fuurnas")));
        BoxCookTickAction.overridePlayerDropInner("069a79f4-44e9-4726-a5be-fca90e38aaf5", new ItemStack((ItemLike)Items.f_42437_));
        BoxCookTickAction.overridePlayerDropInner("853c80ef-3c37-49fd-aa49-938b674adae6", new ItemStack((ItemLike)Items.f_42639_).m_41714_((Component)Component.m_237113_((String)"jeb_")));
        BoxCookTickAction.overridePlayerDropInner("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6", new ItemStack((ItemLike)Items.f_42639_).m_41714_((Component)Component.m_237113_((String)"Dinnerbone")));
        BoxCookTickAction.overridePlayerDropInner("bbb87dbe-690f-4205-bdc5-72ffb8ebc29d", new ItemStack((ItemLike)Blocks.f_50652_, 45).m_41714_((Component)Component.m_237113_((String)"direwolf20")));
        BoxCookTickAction.overridePlayerDropInner("0b7509f0-2458-4160-9ce1-2772b9a45ac2", new ItemStack((ItemLike)Items.f_42485_));
        PLAYERDROP_RANDOM = new ItemStack[]{new ItemStack((ItemLike)Items.f_42517_), new ItemStack((ItemLike)Items.f_42593_), new ItemStack((ItemLike)Items.f_42692_), new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42592_), new ItemStack((ItemLike)Items.f_42590_), new ItemStack((ItemLike)Items.f_42617_), new ItemStack((ItemLike)Items.f_42449_), new ItemStack((ItemLike)Items.f_42574_), new ItemStack((ItemLike)Items.f_41909_), new ItemStack((ItemLike)Items.f_42687_), new ItemStack((ItemLike)Items.f_42542_), new ItemStack((ItemLike)Items.f_42450_), new ItemStack((ItemLike)Items.f_42546_), new ItemStack((ItemLike)Items.f_42387_), new ItemStack((ItemLike)Items.f_42684_), new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)Blocks.f_50353_), new ItemStack((ItemLike)Blocks.f_50060_), new ItemStack((ItemLike)Blocks.f_50135_), new ItemStack((ItemLike)Blocks.f_49994_), new ItemStack((ItemLike)Blocks.f_50332_)};
    }
}

