/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;

public class BlockEntityDarkTank
extends BlockEntityTankInventory {
    public static final int BASE_CAPACITY = 16000;
    @NBTPersist
    private boolean enabled;

    public BlockEntityDarkTank(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_DARK_TANK, blockPos, blockState, 0, 0, 16000, null);
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.sendUpdate();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    protected ItemStack fill(ItemStack itemStack) {
        FluidStack fluidStack;
        IFluidHandlerItem container = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (container.fill(fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount())), IFluidHandler.FluidAction.SIMULATE) > 0) {
            int filled = container.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
            return container.getContainer();
        }
        return null;
    }

    @Override
    public void onTankChanged() {
        super.onTankChanged();
        this.sendUpdate();
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityDarkTank> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityDarkTank blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (!blockEntity.getTank().isEmpty() && blockEntity.isEnabled()) {
                Direction down = Direction.DOWN;
                IFluidHandler handler = (IFluidHandler)BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_121945_(down), (Direction)down.m_122424_(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
                if (handler != null) {
                    FluidStack fluidStack = new FluidStack(blockEntity.getTank().getFluid(), Math.min(GeneralConfig.mbFlowRate, blockEntity.getTank().getFluidAmount()));
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        blockEntity.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    List entities = level.m_6443_(Entity.class, new AABB(pos.m_121945_(down), pos.m_121945_(down).m_7918_(1, 1, 1)), EntitySelector.f_20402_);
                    for (Entity entity : entities) {
                        if (!blockEntity.getTank().isEmpty() && entity instanceof ItemEntity) {
                            ItemStack itemStack;
                            ItemStack fillItemStack;
                            ItemEntity item = (ItemEntity)entity;
                            if (item.m_32055_() == null || !item.m_32055_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() || item.m_32055_().m_41613_() != 1 || (fillItemStack = blockEntity.fill(itemStack = item.m_32055_().m_41777_())) == null) continue;
                            item.m_32045_(fillItemStack);
                            continue;
                        }
                        if (!(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                        while (!blockEntity.getTank().isEmpty() && it.hasNext()) {
                            ItemStack fillItemStack;
                            ItemStack itemStack = it.next();
                            if (itemStack.m_41619_() || !itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() || (fillItemStack = blockEntity.fill(itemStack)) == null) continue;
                            it.replace(fillItemStack);
                        }
                    }
                }
            }
        }
    }
}

