/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public abstract class UpdateDimBase {
    protected BlockPos pos;
    protected Frequency freq;
    protected boolean locked;

    public UpdateDimBase(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.freq = Frequency.readFromPacket(buf);
        this.locked = buf.readBoolean();
    }

    public UpdateDimBase(BlockEntityFrequencyOwner blockentity) {
        this.pos = blockentity.m_58899_();
        this.freq = blockentity.getFrequency();
        this.locked = blockentity.locked;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        this.freq.writeToPacket(buf);
        buf.writeBoolean(this.locked);
    }

    public abstract void customHandle(Level var1, ServerPlayer var2);

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            if (level.m_46749_(this.pos)) {
                this.customHandle(level, player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

