/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import com.mojang.blaze3d.vertex.PoseStack;
import edivad.dimstorage.client.screen.pattern.BaseScreen;
import edivad.dimstorage.setup.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PanelScreen<T extends AbstractContainerMenu>
extends BaseScreen<T> {
    private static final int ANIMATION_SPEED = 10;
    private static final int SETTINGS_WIDTH = 80;
    private static final int SETTINGS_HEIGHT = 180;
    private static final int BUTTON_WIDTH = 20;
    private SettingsState state;
    private int animationState;
    protected boolean drawSettings;
    private boolean settingsButtonOver;
    private final boolean allowConfig;
    private List<AbstractWidget> component;

    public PanelScreen(T container, Inventory inventory, Component text, ResourceLocation background, boolean drawSettings) {
        super(container, inventory, text, background);
        this.drawSettings = drawSettings;
        this.settingsButtonOver = false;
        this.allowConfig = (Boolean)Config.DimBlock.ALLOW_CONFIG.get();
        this.component = new ArrayList<AbstractWidget>();
        if (this.drawSettings) {
            this.animationState = 80;
            this.state = SettingsState.STATE_OPENED;
        } else {
            this.animationState = 0;
            this.state = SettingsState.STATE_CLOSED;
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.state == SettingsState.STATE_OPENING) {
            this.animationState += 10;
            if (this.animationState >= 80) {
                this.animationState = 80;
                this.state = SettingsState.STATE_OPENED;
                this.drawSettings(true);
            }
        } else if (this.state == SettingsState.STATE_CLOSING) {
            this.drawSettings(false);
            this.animationState -= 10;
            if (this.animationState <= 0) {
                this.animationState = 0;
                this.state = SettingsState.STATE_CLOSED;
            }
        }
    }

    private int getButtonX() {
        return this.f_97735_ + this.f_97726_;
    }

    private int getButtonY() {
        return this.f_97736_ + 16;
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickedButton) {
        super.m_6375_(mouseX, mouseY, clickedButton);
        if (this.allowConfig && mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            if (this.state == SettingsState.STATE_CLOSED) {
                this.state = SettingsState.STATE_OPENING;
            } else if (this.state == SettingsState.STATE_OPENED) {
                this.state = SettingsState.STATE_CLOSING;
            }
            return true;
        }
        return false;
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.settingsButtonOver = false;
        if (mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            this.settingsButtonOver = true;
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int settingsX = this.f_97735_ + (this.f_97726_ - 80);
        if (this.allowConfig) {
            this.m_93228_(poseStack, settingsX + this.animationState, this.f_97736_ + 36, this.f_97726_, 36, 80, this.f_97727_);
        }
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_ + 2);
        this.m_93228_(poseStack, this.getButtonX(), this.getButtonY(), this.f_97726_, 16, 20, 20);
        if (this.state == SettingsState.STATE_CLOSED || this.state == SettingsState.STATE_OPENING) {
            if (this.settingsButtonOver) {
                this.m_93228_(poseStack, this.getButtonX() + 6, this.getButtonY() - 3, this.f_97726_ + 28, 16, 8, 20);
            } else {
                this.m_93228_(poseStack, this.getButtonX() + 6, this.getButtonY() - 3, this.f_97726_ + 20, 16, 8, 20);
            }
        } else if (this.state == SettingsState.STATE_OPENED || this.state == SettingsState.STATE_CLOSING) {
            if (this.settingsButtonOver) {
                this.m_93228_(poseStack, this.getButtonX() + 4, this.getButtonY() - 3, this.f_97726_ + 44, 16, 8, 20);
            } else {
                this.m_93228_(poseStack, this.getButtonX() + 4, this.getButtonY() - 3, this.f_97726_ + 36, 16, 8, 20);
            }
        }
    }

    public List<Rect2i> getAreas() {
        ArrayList<Rect2i> extraAreas = new ArrayList<Rect2i>();
        extraAreas.add(new Rect2i(this.f_97735_ + this.f_97726_, this.getButtonY(), 20, 20));
        extraAreas.add(new Rect2i(this.f_97735_ + this.f_97726_, this.getButtonY() + 20, this.animationState, 180));
        return extraAreas;
    }

    protected void clearComponent() {
        this.component.clear();
    }

    protected void addComponent(AbstractWidget widget) {
        this.component.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }

    protected void drawSettings(boolean draw) {
        this.drawSettings = draw;
        for (AbstractWidget widget : this.component) {
            widget.f_93624_ = draw;
        }
    }

    private static enum SettingsState {
        STATE_CLOSED,
        STATE_OPENING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

