/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class ElseRecipe {
    @ObjectHolder(registryName="recipe_serializer", value="delightful:else")
    public static final RecipeSerializer<Recipe<?>> SERIALZIER = null;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ICondition[] conditions;
        private FinishedRecipe recipe;
        private FinishedRecipe elseRecipe;
        private ResourceLocation advId;
        private ConditionalAdvancement.Builder adv;
        private final List<ICondition> currentConditions = new ArrayList<ICondition>();

        public Builder addCondition(ICondition condition) {
            this.currentConditions.add(condition);
            return this;
        }

        public Builder setRecipe(Consumer<Consumer<FinishedRecipe>> callable) {
            callable.accept(this::setRecipe);
            return this;
        }

        public Builder setRecipe(FinishedRecipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public Builder setElseRecipe(Consumer<Consumer<FinishedRecipe>> callable) {
            callable.accept(this::setElseRecipe);
            return this;
        }

        public Builder setElseRecipe(FinishedRecipe elseRecipe) {
            this.elseRecipe = elseRecipe;
            return this;
        }

        public Builder generateAdvancement() {
            return this.generateAdvancement(null);
        }

        public Builder generateAdvancement(@Nullable ResourceLocation id) {
            ConditionalAdvancement.Builder builder = ConditionalAdvancement.builder();
            for (ICondition cond : this.currentConditions) {
                builder.addCondition(cond);
            }
            builder = builder.addAdvancement(this.recipe);
            return this.setAdvancement(id, builder);
        }

        public Builder setAdvancement(ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(null, advancement);
        }

        public Builder setAdvancement(String namespace, String path, ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(new ResourceLocation(namespace, path), advancement);
        }

        public Builder setAdvancement(@Nullable ResourceLocation id, ConditionalAdvancement.Builder advancement) {
            if (this.adv != null) {
                throw new IllegalStateException("Invalid ConditionalRecipeBuilder, Advancement already set");
            }
            this.advId = id;
            this.adv = advancement;
            return this;
        }

        public void build(Consumer<FinishedRecipe> consumer, String namespace, String path) {
            this.build(consumer, new ResourceLocation(namespace, path));
        }

        public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (!this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.advId == null && this.adv != null) {
                this.advId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
            }
            consumer.accept(new Finished(id, this.currentConditions, this.recipe, this.elseRecipe, this.advId, this.adv));
        }
    }

    private static class Finished
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<ICondition> conditions;
        private final FinishedRecipe recipe;
        private final FinishedRecipe elseRecipe;
        private final ResourceLocation advId;
        private final ConditionalAdvancement.Builder adv;

        private Finished(ResourceLocation id, List<ICondition> conditions, FinishedRecipe recipe, FinishedRecipe elseRecipe, @Nullable ResourceLocation advId, @Nullable ConditionalAdvancement.Builder adv) {
            this.id = id;
            this.conditions = conditions;
            this.recipe = recipe;
            this.elseRecipe = elseRecipe;
            this.advId = advId;
            this.adv = adv;
        }

        public void m_7917_(JsonObject json) {
            JsonArray conds = new JsonArray();
            for (ICondition c : this.conditions) {
                conds.add((JsonElement)CraftingHelper.serialize((ICondition)c));
            }
            json.add("conditions", (JsonElement)conds);
            json.add("recipe", (JsonElement)this.recipe.m_125966_());
            json.add("else", (JsonElement)this.elseRecipe.m_125966_());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return SERIALZIER;
        }

        public JsonObject m_5860_() {
            return this.adv == null ? null : this.adv.write();
        }

        public ResourceLocation m_6448_() {
            return this.advId;
        }
    }

    public static class Serializer<T extends Recipe<?>>
    implements RecipeSerializer<T> {
        public T m_6729_(ResourceLocation recipeId, JsonObject json) {
            return this.fromJson(recipeId, json, ICondition.IContext.EMPTY);
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("Invalid recipe entry. Must be JsonObject");
            }
            if (CraftingHelper.processConditions((JsonArray)GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"conditions"), (ICondition.IContext)context)) {
                return (T)RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13930_((JsonObject)json.getAsJsonObject(), (String)"recipe"));
            }
            return (T)RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13930_((JsonObject)json.getAsJsonObject(), (String)"else"));
        }

        public T m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return null;
        }

        public void m_6178_(FriendlyByteBuf buffer, T recipe) {
        }
    }
}

