/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.base.Predicates;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandler {
    private final ModBase mod;
    private SimpleChannel networkChannel = null;

    public PacketHandler(ModBase mod) {
        this.mod = mod;
    }

    public void init() {
        if (this.networkChannel == null) {
            this.networkChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(this.mod.getModId(), "channel_main"), () -> "1.0.0", (Predicate)Predicates.alwaysTrue(), (Predicate)Predicates.alwaysTrue());
        }
    }

    public <P extends PacketBase> void register(Class<P> packetType) {
        int discriminator = Helpers.getNewId(this.mod, Helpers.IDType.PACKET);
        try {
            Constructor constructor = packetType.getConstructor(new Class[0]);
            this.networkChannel.registerMessage(discriminator, packetType, (packet, packetBuffer) -> packet.encode((FriendlyByteBuf)packetBuffer), packetBuffer -> {
                PacketBase packet = null;
                try {
                    packet = (PacketBase)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                packet.decode((FriendlyByteBuf)packetBuffer);
                return packet;
            }, (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (context.getDirection().getReceptionSide().isClient()) {
                    if (packet.isAsync()) {
                        this.handlePacketClient(context, (PacketBase)packet);
                    } else {
                        context.enqueueWork(() -> this.handlePacketClient(context, (PacketBase)packet));
                    }
                } else if (packet.isAsync()) {
                    this.handlePacketServer(context, (PacketBase)packet);
                } else {
                    context.enqueueWork(() -> this.handlePacketServer(context, (PacketBase)packet));
                }
                context.setPacketHandled(true);
            });
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            CyclopsCore.clog(org.apache.logging.log4j.Level.ERROR, "Could not find a default constructor for packet " + packetType.getName());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketClient(NetworkEvent.Context context, PacketBase packet) {
        packet.actionClient(Minecraft.m_91087_().f_91074_.f_19853_, (Player)Minecraft.m_91087_().f_91074_);
    }

    public void handlePacketServer(NetworkEvent.Context context, PacketBase packet) {
        packet.actionServer((Level)context.getSender().m_9236_(), context.getSender());
    }

    public void sendToServer(PacketBase packet) {
        this.networkChannel.sendToServer((Object)packet);
    }

    public void sendToPlayer(PacketBase packet, ServerPlayer player) {
        this.networkChannel.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToAllAround(PacketBase packet, PacketDistributor.TargetPoint point) {
        PacketDistributor.PacketTarget target = PacketDistributor.NEAR.with(() -> point);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }

    public void sendToDimension(PacketBase packet, ResourceKey<Level> dimension) {
        PacketDistributor.PacketTarget target = PacketDistributor.DIMENSION.with(() -> dimension);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }

    public void sendToAll(PacketBase packet) {
        PacketDistributor.PacketTarget target = PacketDistributor.ALL.with(() -> null);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }
}

