/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class NarslimmusBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 2;
    private static final int MAX_MANA = NarslimmusBlockEntity.manaForSize(4);

    public NarslimmusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.NARSLIMMUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 5 == 0) {
            List slimes = this.m_58904_().m_45976_(Slime.class, new AABB(this.getEffectivePos().m_7918_(-2, -2, -2), this.getEffectivePos().m_7918_(3, 3, 3)));
            for (Slime slime : slimes) {
                if (!slime.m_6084_() || !XplatAbstractions.INSTANCE.narslimmusComponent(slime).isNaturalSpawned()) continue;
                int size = slime.m_33632_();
                if (!slime.m_9236_().f_46443_) {
                    slime.m_146870_();
                    slime.m_5496_(size > 1 ? BotaniaSounds.narslimmusEatBig : BotaniaSounds.narslimmusEatSmall, 1.0f, 1.0f);
                    this.addMana(NarslimmusBlockEntity.manaForSize(size));
                    this.sync();
                }
                int times = 8 * (int)Math.pow(2.0, size);
                for (int j = 0; j < times; ++j) {
                    float f = slime.m_9236_().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
                    float f1 = slime.m_9236_().f_46441_.m_188501_() * 0.5f + 0.5f;
                    float f2 = Mth.m_14031_((float)f) * (float)size * 0.5f * f1;
                    float f3 = Mth.m_14089_((float)f) * (float)size * 0.5f * f1;
                    float f4 = slime.m_9236_().f_46441_.m_188501_() * (float)size * 0.5f * f1;
                    slime.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123753_, slime.m_20185_() + (double)f2, slime.m_20191_().f_82289_ + (double)f4, slime.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static int manaForSize(int size) {
        size = Math.min(size, 4);
        return 1200 * (int)Math.pow(2.0, size);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public int getMaxMana() {
        return MAX_MANA;
    }

    @Override
    public int getColor() {
        return 7455603;
    }

    public static void onSpawn(Entity entity) {
        boolean slimeChunk = NarslimmusBlockEntity.isSlimeChunk(entity.m_9236_(), entity.m_20185_(), entity.m_20189_());
        if (slimeChunk) {
            entity.m_20199_().forEach(e -> {
                if (e instanceof Slime) {
                    Slime slime = (Slime)e;
                    XplatAbstractions.INSTANCE.narslimmusComponent(slime).setNaturalSpawn(true);
                }
            });
        }
    }

    private static boolean isSlimeChunk(Level world, double x, double z) {
        return NarslimmusBlockEntity.isSlimeChunk(world, new BlockPos(x, 0.0, z));
    }

    public static boolean isSlimeChunk(Level world, BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos);
        return WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)((ServerLevel)world).m_7328_(), (long)987234911L).m_188503_(10) == 0;
    }
}

