/*
 * Decompiled with CFR 0.152.
 */
package appbot.item.cell;

import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appbot.item.cell.IManaCellItem;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ManaCellInventory
implements StorageCell {
    private static final String AMOUNT = "amount";
    private final IManaCellItem cellType;
    private final ItemStack i;
    private final ISaveProvider container;
    private long storedMana;
    private boolean isPersisted = true;

    public ManaCellInventory(IManaCellItem cellType, ItemStack o, ISaveProvider container) {
        this.cellType = cellType;
        this.i = o;
        this.container = container;
        this.storedMana = this.getTag().m_128454_(AMOUNT);
        String ITEM_COUNT_TAG = "ic";
        String STACK_KEYS = "keys";
        String STACK_AMOUNTS = "amts";
        if (this.getTag().m_128441_(ITEM_COUNT_TAG)) {
            long[] amounts = this.getTag().m_128467_(STACK_AMOUNTS);
            ListTag tags = this.getTag().m_128437_(STACK_KEYS, 10);
            for (int i = 0; i < amounts.length; ++i) {
                if (AEKey.fromTagGeneric((CompoundTag)tags.m_128728_(i)) != ManaKey.KEY) continue;
                this.storedMana += amounts[i];
            }
            this.getTag().m_128473_(ITEM_COUNT_TAG);
            this.getTag().m_128473_(STACK_KEYS);
            this.getTag().m_128473_(STACK_AMOUNTS);
            this.saveChanges();
        }
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public CellState getStatus() {
        if (this.storedMana == 0L) {
            return CellState.EMPTY;
        }
        if (this.storedMana == this.getMaxMana()) {
            return CellState.FULL;
        }
        if (this.storedMana > this.getMaxMana() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    private long getMaxMana() {
        return this.cellType.getTotalBytes() * (long)ManaKeyType.TYPE.getAmountPerByte();
    }

    protected long getTotalBytes() {
        return this.cellType.getTotalBytes();
    }

    protected long getUsedBytes() {
        int amountPerByte = ManaKeyType.TYPE.getAmountPerByte();
        return (this.storedMana + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long inserted = Math.min(this.getMaxMana() - this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana += inserted;
            this.saveChanges();
        }
        return inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long extracted = Math.min(this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana -= extracted;
            this.saveChanges();
        }
        return extracted;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedMana <= 0L) {
            this.getTag().m_128473_(AMOUNT);
        } else {
            this.getTag().m_128356_(AMOUNT, this.storedMana);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedMana > 0L) {
            out.add(ManaKey.KEY, this.storedMana);
        }
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

