/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.core.attributeslib.impl;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.core.attributeslib.AttributesLib;
import shadows.apotheosis.core.attributeslib.api.ALAttributes;
import shadows.apotheosis.core.attributeslib.api.AttributeHelper;
import shadows.apotheosis.core.attributeslib.api.IFormattableAttribute;
import shadows.apotheosis.core.attributeslib.packet.CritParticleMessage;
import shadows.apotheosis.core.attributeslib.util.AttributesUtil;
import shadows.placebo.network.PacketDistro;

public class AttributeEvents {
    private static boolean noRecurse = false;
    private static Random dodgeRand = new Random();

    @SubscribeEvent
    public void fixChangedAttributes(PlayerEvent.PlayerLoggedInEvent e) {
        AttributeMap map = e.getEntity().m_21204_();
        for (Map.Entry entry : Registry.f_122866_.m_6579_()) {
            if (!"apotheosis".equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
            map.m_22146_((Attribute)entry.getValue()).m_22100_(((RangedAttribute)entry.getValue()).m_22082_());
        }
        map.m_22146_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22100_(0.6);
    }

    private boolean canBenefitFromDrawSpeed(ItemStack stack) {
        return stack.m_41720_() instanceof ProjectileWeaponItem || stack.m_41720_() instanceof TridentItem;
    }

    @SubscribeEvent
    public void drawSpeed(LivingEntityUseItemEvent.Tick e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            int mod;
            Player player = (Player)livingEntity;
            double t = player.m_21051_((Attribute)ALAttributes.DRAW_SPEED.get()).m_22135_() - 1.0;
            if (t == 0.0 || !this.canBenefitFromDrawSpeed(e.getItem())) {
                return;
            }
            int offset = -1;
            if (t < 0.0) {
                offset = 1;
                t = -t;
            }
            while (t > 1.0) {
                e.setDuration(e.getDuration() + offset);
                t -= 1.0;
            }
            if (t > 0.5) {
                if (e.getEntity().f_19797_ % 2 == 0) {
                    e.setDuration(e.getDuration() + offset);
                }
                t -= 0.5;
            }
            if (e.getEntity().f_19797_ % (mod = (int)Math.floor(1.0 / Math.min(1.0, t))) == 0) {
                e.setDuration(e.getDuration() + offset);
            }
            double d = t - 1.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void lifeStealOverheal(LivingHurtEvent e) {
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                float lifesteal = (float)attacker.m_21133_((Attribute)ALAttributes.LIFE_STEAL.get());
                float dmg = Math.min(e.getAmount(), e.getEntity().m_21223_());
                if ((double)lifesteal > 0.001) {
                    attacker.m_5634_(dmg * lifesteal);
                }
                float overheal = (float)attacker.m_21133_((Attribute)ALAttributes.OVERHEAL.get());
                float maxOverheal = attacker.m_21233_() * 0.5f;
                if (overheal > 0.0f && attacker.m_6103_() < maxOverheal) {
                    attacker.m_7911_(Math.min(maxOverheal, attacker.m_6103_() + dmg * overheal));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void meleeDamageAttributes(LivingAttackEvent e) {
        if (e.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (noRecurse) {
            return;
        }
        noRecurse = true;
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                float hpDmg = (float)attacker.m_21133_((Attribute)ALAttributes.CURRENT_HP_DAMAGE.get());
                float fireDmg = (float)attacker.m_21133_((Attribute)ALAttributes.FIRE_DAMAGE.get());
                float coldDmg = (float)attacker.m_21133_((Attribute)ALAttributes.COLD_DAMAGE.get());
                LivingEntity target = e.getEntity();
                int time = target.f_19802_;
                target.f_19802_ = 0;
                if ((double)hpDmg > 0.001 && Apotheosis.localAtkStrength >= 0.85f) {
                    target.m_6469_(AttributeEvents.src(attacker), Apotheosis.localAtkStrength * hpDmg * target.m_21223_());
                }
                target.f_19802_ = 0;
                if ((double)fireDmg > 0.001 && Apotheosis.localAtkStrength >= 0.55f) {
                    target.m_6469_(AttributeEvents.src(attacker).m_19389_().m_19380_(), Apotheosis.localAtkStrength * fireDmg);
                    target.m_7311_(target.m_20094_() + (int)(10.0f * fireDmg));
                }
                target.f_19802_ = 0;
                if ((double)coldDmg > 0.001 && Apotheosis.localAtkStrength >= 0.55f) {
                    target.m_6469_(AttributeEvents.src(attacker).m_19389_().m_19380_(), Apotheosis.localAtkStrength * coldDmg);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(15.0f * coldDmg), Mth.m_14143_((float)(coldDmg / 5.0f))));
                }
                target.f_19802_ = time;
            }
        }
        noRecurse = false;
    }

    private static DamageSource src(LivingEntity entity) {
        DamageSource damageSource;
        if (entity instanceof Player) {
            Player p = (Player)entity;
            damageSource = DamageSource.m_19344_((Player)p);
        } else {
            damageSource = DamageSource.m_19370_((LivingEntity)entity);
        }
        return damageSource;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void apothCriticalStrike(LivingHurtEvent e) {
        LivingEntity le;
        LivingEntity attacker;
        Entity entity = e.getSource().m_7639_();
        LivingEntity livingEntity = attacker = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        if (attacker == null) {
            return;
        }
        double critChance = attacker.m_21133_((Attribute)ALAttributes.CRIT_CHANCE.get());
        RandomSource rand = e.getEntity().f_19796_;
        float critMult = 1.0f;
        for (float critDmg = (float)attacker.m_21133_((Attribute)ALAttributes.CRIT_DAMAGE.get()); (double)rand.m_188501_() <= critChance && critDmg > 1.0f; critDmg *= 0.85f) {
            critChance -= 1.0;
            critMult *= critDmg;
        }
        e.setAmount(e.getAmount() * critMult);
        if (critMult > 1.0f && !attacker.f_19853_.f_46443_) {
            PacketDistro.sendToTracking((SimpleChannel)AttributesLib.CHANNEL, (Object)new CritParticleMessage(e.getEntity().m_19879_()), (ServerLevel)((ServerLevel)attacker.f_19853_), (BlockPos)e.getEntity().m_20183_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void vanillaCritDmg(CriticalHitEvent e) {
        float critDmg = (float)e.getEntity().m_21133_((Attribute)ALAttributes.CRIT_DAMAGE.get());
        if (e.isVanillaCritical()) {
            e.setDamageModifier(Math.max(e.getDamageModifier(), critDmg));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void breakSpd(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed(e.getNewSpeed() * (float)e.getEntity().m_21133_((Attribute)ALAttributes.MINING_SPEED.get()));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockBreak(BlockEvent.BreakEvent e) {
        double xpMult = e.getPlayer().m_21133_((Attribute)ALAttributes.EXPERIENCE_GAINED.get());
        e.setExpToDrop((int)((double)e.getExpToDrop() * xpMult));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void mobXp(LivingExperienceDropEvent e) {
        Player player = e.getAttackingPlayer();
        if (player == null) {
            return;
        }
        double xpMult = e.getAttackingPlayer().m_21133_((Attribute)ALAttributes.EXPERIENCE_GAINED.get());
        e.setDroppedExperience((int)((double)e.getDroppedExperience() * xpMult));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void heal(LivingHealEvent e) {
        float factor = (float)e.getEntity().m_21133_((Attribute)ALAttributes.HEALING_RECEIVED.get());
        e.setAmount(e.getAmount() * factor);
        if (e.getAmount() <= 0.0f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void arrow(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.f_19853_.f_46443_ || arrow.getPersistentData().m_128471_("attributeslib.arrow.done")) {
                return;
            }
            Entity entity2 = arrow.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity2;
                arrow.m_36781_(arrow.m_36789_() * le.m_21133_((Attribute)ALAttributes.ARROW_DAMAGE.get()));
                arrow.m_20256_(arrow.m_20184_().m_82490_(le.m_21133_((Attribute)ALAttributes.ARROW_VELOCITY.get())));
            }
            arrow.getPersistentData().m_128379_("attributeslib.arrow.done", true);
        }
    }

    private static double getAttackReachSqr(Entity attacker, LivingEntity pAttackTarget) {
        return attacker.m_20205_() * 2.0f * attacker.m_20205_() * 2.0f + pAttackTarget.m_20205_();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(LivingAttackEvent e) {
        LivingEntity target = e.getEntity();
        if (target.f_19853_.f_46443_) {
            return;
        }
        Entity attacker = e.getSource().m_7640_();
        if (attacker instanceof LivingEntity) {
            double d;
            double dodgeChance = target.m_21133_((Attribute)ALAttributes.DODGE_CHANCE.get());
            if (attacker instanceof Player) {
                Player p = (Player)attacker;
                d = p.getAttackRange() * p.getAttackRange();
            } else {
                d = AttributeEvents.getAttackReachSqr(attacker, target);
            }
            double atkRangeSqr = d;
            dodgeRand.setSeed(target.f_19797_);
            if (attacker.m_20280_((Entity)target) <= atkRangeSqr && (double)dodgeRand.nextFloat() <= dodgeChance) {
                this.onDodge(target);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(ProjectileImpactEvent e) {
        Entity target;
        HitResult hitResult = e.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entRes = (EntityHitResult)hitResult;
            v0 = entRes.m_82443_();
        } else {
            v0 = target = null;
        }
        if (target instanceof LivingEntity) {
            LivingEntity lvTarget = (LivingEntity)target;
            double dodgeChance = lvTarget.m_21133_((Attribute)ALAttributes.DODGE_CHANCE.get());
            dodgeRand.setSeed(target.f_19797_);
            if ((double)dodgeRand.nextFloat() <= dodgeChance) {
                this.onDodge(lvTarget);
                e.setCanceled(true);
            }
        }
    }

    private void onDodge(LivingEntity target) {
        target.f_19853_.m_6269_(null, (Entity)target, (SoundEvent)AttributesLib.DODGE_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 0.7f + target.f_19796_.m_188501_() * 0.3f);
        Level level = target.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            double height = target.m_20206_();
            double width = target.m_20205_();
            sl.m_8767_((ParticleOptions)ParticleTypes.f_123755_, target.m_20185_() - width / 4.0, target.m_20186_(), target.m_20189_() - width / 4.0, 6, -width / 4.0, height / 8.0, -width / 4.0, 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void fixMCF9370(ProjectileImpactEvent e) {
        if (e.isCanceled()) {
            AbstractArrow arrow;
            Entity entity;
            HitResult hitResult = e.getRayTraceResult();
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entRes = (EntityHitResult)hitResult;
                entity = entRes.m_82443_();
            } else {
                entity = null;
            }
            Entity target = entity;
            Projectile proj = e.getProjectile();
            if (target != null && proj instanceof AbstractArrow && (arrow = (AbstractArrow)proj).m_36796_() > 0) {
                if (arrow.f_36701_ == null) {
                    arrow.f_36701_ = new IntOpenHashSet((int)arrow.m_36796_());
                }
                arrow.f_36701_.add(target.m_19879_());
            }
        }
    }

    @SubscribeEvent
    public void affixModifiers(ItemAttributeModifierEvent e) {
        boolean hasBaseAR;
        boolean hasBaseAD = e.getModifiers().get((Object)Attributes.f_22281_).stream().filter(m -> ((IFormattableAttribute)Attributes.f_22281_).getBaseUUID().equals(m.m_22209_())).findAny().isPresent();
        if (hasBaseAD && !(hasBaseAR = e.getModifiers().get((Object)((Attribute)ForgeMod.ATTACK_RANGE.get())).stream().filter(m -> ((IFormattableAttribute)ForgeMod.ATTACK_RANGE.get()).getBaseUUID().equals(m.m_22209_())).findAny().isPresent())) {
            e.addModifier((Attribute)ForgeMod.ATTACK_RANGE.get(), new AttributeModifier(AttributeHelper.BASE_ATTACK_RANGE, () -> "attributeslib:fake_base_range", 0.0, AttributeModifier.Operation.ADDITION));
        }
    }
}

