/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.world.entity.player.Player;
import shadows.apotheosis.adventure.AdventureModule;

public class GameStagesCompat {
    public static boolean hasStage(Player player, Set<String> stages) {
        return !AdventureModule.STAGES_LOADED || stages == null || Inner.hasStage(player, stages);
    }

    private static class Inner {
        private Inner() {
        }

        private static boolean hasStage(Player player, Set<String> stages) {
            return GameStageHelper.hasAnyOf((Player)player, stages);
        }
    }

    public static interface IStaged {
        @Nullable
        public Set<String> getStages();

        public static <T extends IStaged> Predicate<T> matches(Player player) {
            return obj -> GameStagesCompat.hasStage(player, obj.getStages());
        }
    }
}

