/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat.thermal;

import dev.denismasterherobrine.angelring.compat.curios.AbstractRingCurio;
import dev.denismasterherobrine.angelring.config.Configuration;
import dev.denismasterherobrine.angelring.item.utils.EnergyItem;
import dev.denismasterherobrine.angelring.register.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ReinforcedAngelRingIntegration {
    public static ICapabilityProvider initCapabilities(final ItemStack stack) {
        final AbstractRingCurio curio = new AbstractRingCurio((Item)ItemRegistry.REINFORCED_ANGEL_RING.get()){
            private final int fePerTick;
            {
                super(item);
                this.fePerTick = (Integer)Configuration.ReinforcedFEPerTick.get();
            }

            public ItemStack getStack() {
                return stack;
            }

            private IEnergyStorage getEnergyStorage(ItemStack stack2) {
                return (IEnergyStorage)this.getStack().getCapability(ForgeCapabilities.ENERGY).resolve().get();
            }

            @Override
            protected boolean checkIfAllowedToFly(Player player, ItemStack stack2) {
                return this.getEnergyStorage(this.getStack()).getEnergyStored() > 1;
            }

            @Override
            protected Component getNotAbleToFlyMessage() {
                return Component.m_237115_((String)"item.angelring.energetic_angel_ring.not_enough_fe");
            }

            @Override
            protected void payForFlight(Player player, ItemStack stack2) {
                this.getEnergyStorage(this.getStack()).extractEnergy(this.fePerTick, false);
            }
        };
        final EnergyItem energyItem = new EnergyItem(stack, (Integer)Configuration.ReinforcedCapacity.get());
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);
            private final LazyOptional<IEnergyStorage> energyStorageOpt = LazyOptional.of(() -> energyItem);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return this.energyStorageOpt.cast();
                }
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack angelRing, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(angelRing.m_41720_(), player).isPresent();
    }
}

