/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@FieldsAreNonnullByDefault
public class PeripheralsConfig
implements IAPConfig {
    public final ForgeConfigSpec.IntValue playerDetMaxRange;
    public final ForgeConfigSpec.BooleanValue playerSpy;
    public final ForgeConfigSpec.BooleanValue morePlayerInformation;
    public final ForgeConfigSpec.BooleanValue enablePlayerDetector;
    public final ForgeConfigSpec.IntValue energyDetectorMaxFlow;
    public final ForgeConfigSpec.BooleanValue enableEnergyDetector;
    public final ForgeConfigSpec.IntValue nbtStorageMaxSize;
    public final ForgeConfigSpec.BooleanValue enableNBTStorage;
    public final ForgeConfigSpec.IntValue chunkLoadValidTime;
    public final ForgeConfigSpec.BooleanValue enableChunkyTurtle;
    public final ForgeConfigSpec.BooleanValue enableChatBox;
    public final ForgeConfigSpec.ConfigValue<String> defaultChatBoxPrefix;
    public final ForgeConfigSpec.BooleanValue enableMEBridge;
    public final ForgeConfigSpec.IntValue meConsumption;
    public final ForgeConfigSpec.BooleanValue enableRSBridge;
    public final ForgeConfigSpec.IntValue rsConsumption;
    public final ForgeConfigSpec.BooleanValue enableEnvironmentDetector;
    public final ForgeConfigSpec.BooleanValue enableARGoggles;
    public final ForgeConfigSpec.BooleanValue enableInventoryManager;
    public final ForgeConfigSpec.BooleanValue enableRedstoneIntegrator;
    public final ForgeConfigSpec.BooleanValue enableBlockReader;
    public final ForgeConfigSpec.BooleanValue enableGeoScanner;
    public final ForgeConfigSpec.BooleanValue enableColonyIntegrator;
    public final ForgeConfigSpec.BooleanValue enableCompassTurtle;
    public final ForgeConfigSpec.BooleanValue enablePoweredPeripherals;
    public final ForgeConfigSpec.BooleanValue disablePocketFuelConsumption;
    public final ForgeConfigSpec.IntValue poweredPeripheralMaxEnergyStorage;
    private final ForgeConfigSpec configSpec;

    public PeripheralsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Peripherals config").push("Peripherals");
        builder.push("Player_Detector");
        this.enablePlayerDetector = builder.comment("Enable the Player Detector or not.").define("enablePlayerDetector", true);
        this.playerDetMaxRange = builder.comment("The max range of the player detector functions. If anyone use a higher range, the detector will use this max range").defineInRange("playerDetMaxRange", 100000000, 0, 100000000);
        this.playerSpy = builder.comment("Activates the \"getPlayerPos\" function of the Player Detector").define("enablePlayerPosFunction", true);
        this.morePlayerInformation = builder.comment("Adds more information to `getPlayerPos` of the Player Detector. Like rotation and dimension").define("morePlayerInformation", true);
        this.pop("Energy_Detector", builder);
        this.enableEnergyDetector = builder.comment("Enable the Energy Detector or not.").define("enableEnergyDetector", true);
        this.energyDetectorMaxFlow = builder.comment("Defines the maximum energy flow of the energy detector.").defineInRange("energyDetectorMaxFlow", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.pop("NBT_Storage", builder);
        this.enableNBTStorage = builder.comment("Enable the nbt storage block or not").define("enableNBTStorage", true);
        this.nbtStorageMaxSize = builder.comment("Defines max nbt string length that can be stored in nbt storage").defineInRange("nbtStorageMaxSize", 0x100000, 0, Integer.MAX_VALUE);
        this.pop("Chunky_Turtle", builder);
        this.enableChunkyTurtle = builder.comment("Enable the Chunky Turtle or not.").define("enableChunkyTurtle", true);
        this.chunkLoadValidTime = builder.comment("Time in seconds, while loaded chunk can be consider as valid without touch").defineInRange("chunkLoadValidTime", 600, 60, Integer.MAX_VALUE);
        this.pop("Chat_Box", builder);
        this.enableChatBox = builder.comment("Enable the Chat Box or not.").define("enableChatBox", true);
        this.defaultChatBoxPrefix = builder.comment("Defines default chatbox prefix").define("defaultChatBoxPrefix", (Object)"AP");
        this.pop("ME_Bridge", builder);
        this.enableMEBridge = builder.comment("Enable the Me Bridge or not.").define("enableMeBridge", true);
        this.meConsumption = builder.comment("Power consumption per tick.").defineInRange("mePowerConsumption", 10, 0, Integer.MAX_VALUE);
        this.pop("RS_Bridge", builder);
        this.enableRSBridge = builder.comment("Enable the Rs Bridge or not.").define("enableRsBridge", true);
        this.rsConsumption = builder.comment("Power consumption per tick.").defineInRange("rsPowerConsumption", 10, 0, Integer.MAX_VALUE);
        this.pop("Environment_Detector", builder);
        this.enableEnvironmentDetector = builder.comment("Enable the Environment Detector or not.").define("enableEnvironmentDetector", true);
        this.pop("AR_Controller", builder);
        this.enableARGoggles = builder.comment("Enable the AR goggles or not.").define("enableARGoggles", true);
        this.pop("Inventory_Manager", builder);
        this.enableInventoryManager = builder.comment("Enable the inventory manager or not.").define("enableInventoryManager", true);
        this.pop("Redstone_Integrator", builder);
        this.enableRedstoneIntegrator = builder.comment("Enable the redstone integrator or not.").define("enableRedstoneIntegrator", true);
        this.pop("Block_Reader", builder);
        this.enableBlockReader = builder.comment("Enable the block reader or not.").define("enableBlockReader", true);
        this.pop("Geo_Scanner", builder);
        this.enableGeoScanner = builder.comment("Enable the geo scanner or not.").define("enableGeoScanner", true);
        this.pop("Colony_Integrator", builder);
        this.enableColonyIntegrator = builder.comment("Enable the colony integrator or not.").define("enableColonyIntegrator", true);
        this.pop("Compass_Turtle", builder);
        this.enableCompassTurtle = builder.comment("Enable the compass turtle or not.").define("enableCompassTurtle", true);
        this.pop("Powered_Peripherals", builder);
        this.enablePoweredPeripherals = builder.comment("Enable RF storage for peripherals, that could use it").define("enablePoweredPeripherals", false);
        this.poweredPeripheralMaxEnergyStorage = builder.comment("Defines max energy storage in any powered peripheral").defineInRange("poweredPeripheralMaxEnergyStored", 100000000, 1000000, Integer.MAX_VALUE);
        this.pop("Pocket_Peripherals", builder);
        this.disablePocketFuelConsumption = builder.comment("If true, pockets will have infinite fuel").define("disablePocketFuelConsumption", true);
        this.pop("Operations", builder);
        this.register(SingleOperation.values(), builder);
        this.register(SphereOperation.values(), builder);
        this.register(SimpleFreeOperation.values(), builder);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public String getFileName() {
        return "peripherals";
    }

    @Override
    public ModConfig.Type getType() {
        return ModConfig.Type.COMMON;
    }
}

