/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class AutomataEntityTransferPlugin
extends AutomataCorePlugin {
    private static final String ENTITY_NBT_KEY = "storedEntity";
    private final Predicate<Entity> suitableEntity;

    public AutomataEntityTransferPlugin(AutomataCorePeripheral automataCore, Predicate<Entity> suitableEntity) {
        super(automataCore);
        this.suitableEntity = suitableEntity;
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.CAPTURE_ANIMAL};
    }

    protected boolean isEntityInside() {
        return !((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().m_128469_(ENTITY_NBT_KEY).m_128456_();
    }

    protected void saveEntity(CompoundTag data) {
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().m_128365_(ENTITY_NBT_KEY, (Tag)data);
    }

    protected CompoundTag getEntity() {
        return ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().m_128469_(ENTITY_NBT_KEY);
    }

    protected void removeEntity() {
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().m_128473_(ENTITY_NBT_KEY);
    }

    @Nullable
    protected Entity extractEntity() {
        CompoundTag data = this.getEntity();
        EntityType type = EntityType.m_20632_((String)data.m_128461_("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.m_20615_(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getLevel());
            if (entity == null) {
                return null;
            }
            entity.m_20258_(data);
            return entity;
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult captureAnimal() throws LuaException {
        HitResult entityHit = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).withPlayer(player -> player.findHit(false, true, this.suitableEntity));
        if (entityHit.m_6662_() == HitResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "Nothing found"});
        }
        return this.automataCore.withOperation(SingleOperation.CAPTURE_ANIMAL, context -> {
            LivingEntity entity = (LivingEntity)((EntityHitResult)entityHit).m_82443_();
            if (entity instanceof Player || !entity.m_6084_()) {
                return MethodResult.of((Object[])new Object[]{null, "Unsuitable entity"});
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("entity", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
            entity.m_20240_(nbt);
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            this.saveEntity(nbt);
            return MethodResult.of((Object)true);
        }, context -> {
            if (this.isEntityInside()) {
                return MethodResult.of((Object[])new Object[]{null, "Another entity already captured"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult releaseAnimal() {
        if (!this.isEntityInside()) {
            return MethodResult.of((Object[])new Object[]{null, "No entity is stored"});
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        this.automataCore.addRotationCycle();
        Entity extractedEntity = this.extractEntity();
        if (extractedEntity == null) {
            return MethodResult.of((Object[])new Object[]{null, "Problem with entity unpacking"});
        }
        BlockPos blockPos = owner.getPos().m_121955_(owner.getFacing().m_122436_());
        extractedEntity.m_19890_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
        this.removeEntity();
        owner.getLevel().m_7967_(extractedEntity);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCapturedAnimal() {
        Entity extractedEntity = this.extractEntity();
        return MethodResult.of(LuaConverter.completeEntityToLua(extractedEntity, ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getToolInMainHand()));
    }
}

