/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.ChunkManager;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkyPeripheral
extends BasePeripheral<TurtlePeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "chunky";
    private static final String UUID_TAG = "uuid";
    @Nullable
    private ChunkPos loadedChunk;

    public ChunkyPeripheral(ITurtleAccess turtle, TurtleSide side) {
        super(PERIPHERAL_TYPE, new TurtlePeripheralOwner(turtle, side));
    }

    protected UUID getUUID() {
        CompoundTag data = ((TurtlePeripheralOwner)this.owner).getDataStorage();
        if (!data.m_128441_(UUID_TAG)) {
            data.m_128362_(UUID_TAG, UUID.randomUUID());
            ((TurtlePeripheralOwner)this.owner).markDataStorageDirty();
        }
        return data.m_128342_(UUID_TAG);
    }

    public ChunkPos getChunkPos() {
        return this.getLevel().m_46745_(this.getPos()).m_7697_();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableChunkyTurtle.get();
    }

    public void updateChunkState() {
        ServerLevel level = (ServerLevel)this.getLevel();
        ChunkManager manager = ChunkManager.get(level);
        ChunkPos currentChunk = this.getChunkPos();
        if (this.loadedChunk == null || !this.loadedChunk.equals((Object)currentChunk)) {
            this.setLoadedChunk(currentChunk, manager, level);
        } else {
            manager.touch(this.getUUID());
        }
    }

    protected void setLoadedChunk(@Nullable ChunkPos newChunk, ChunkManager manager, ServerLevel level) {
        if (this.loadedChunk != null) {
            manager.removeForceChunk(level, this.getUUID(), this.loadedChunk);
            level.m_8602_(this.loadedChunk.f_45578_, this.loadedChunk.f_45579_, false);
            this.loadedChunk = null;
        }
        if (newChunk != null) {
            this.loadedChunk = newChunk;
            manager.addForceChunk(level, this.getUUID(), this.loadedChunk);
            level.m_8602_(newChunk.f_45578_, newChunk.f_45579_, true);
        }
    }

    @Override
    public void detach(@NotNull IComputerAccess computer) {
        super.detach(computer);
        ServerLevel level = (ServerLevel)((TurtlePeripheralOwner)this.owner).getLevel();
        ChunkManager manager = ChunkManager.get(Objects.requireNonNull(level));
        this.setLoadedChunk(null, manager, level);
    }
}

