/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.fluid;

import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.PlatformFluidHandler;
import earth.terrarium.botarium.api.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class UniveralFluidHandler
implements PlatformFluidHandler {
    private UniveralFluidHandler() {
    }

    public boolean supportsInsertion() {
        return true;
    }

    public boolean supportsExtraction() {
        return true;
    }

    @Nullable
    public static Optional<UniveralFluidHandler> fromSafe(ItemStackHolder item) {
        if (FluidHooks.isFluidContainingItem((ItemStack)item.getStack())) {
            return Optional.of(new UniveralFluidItemHandler(item));
        }
        return Optional.empty();
    }

    public static UniveralFluidHandler from(ItemStackHolder item) {
        return new UniveralFluidItemHandler(item);
    }

    @Nullable
    public static Optional<UniveralFluidHandler> fromSafe(BlockEntity blockEntity, @Nullable Direction direction) {
        if (FluidHooks.isFluidContainingBlock((BlockEntity)blockEntity, (Direction)direction)) {
            return Optional.of(new UniveralFluidBlockHandler(blockEntity, direction));
        }
        return Optional.empty();
    }

    public static UniveralFluidHandler from(BlockEntity blockEntity, @Nullable Direction direction) {
        return new UniveralFluidBlockHandler(blockEntity, direction);
    }

    public static UniveralFluidHandler from(FluidContainer container) {
        return new UniveralFluidContainerHandler(container);
    }

    public static class UniveralFluidItemHandler
    extends UniveralFluidHandler {
        private final ItemStackHolder item;

        public UniveralFluidItemHandler(ItemStackHolder item) {
            this.item = item;
        }

        private ItemStackHolder getItem(boolean simulate) {
            if (simulate) {
                return new ItemStackHolder(this.item.getStack().m_41777_());
            }
            return this.item;
        }

        private PlatformFluidItemHandler getInternalHandler() {
            return FluidHooks.getItemFluidManager((ItemStack)this.getItem(false).getStack());
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().insertFluid(this.getItem(simulate), fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().extractFluid(this.getItem(simulate), fluid, simulate);
        }

        public int getTankAmount() {
            return this.getInternalHandler().getTankAmount();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getInternalHandler().getFluidInTank(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            ArrayList<FluidHolder> list = new ArrayList<FluidHolder>();
            for (int i = 0; i < this.getTankAmount(); ++i) {
                list.add(this.getFluidInTank(i));
            }
            return list;
        }

        public long getTankCapacity(int tank) {
            return this.getInternalHandler().getTankCapacity(tank);
        }
    }

    public static class UniveralFluidBlockHandler
    extends UniveralFluidHandler {
        private final BlockEntity blockEntity;
        private final Direction direction;

        public UniveralFluidBlockHandler(BlockEntity blockEntity, @Nullable Direction direction) {
            this.blockEntity = blockEntity;
            this.direction = direction;
        }

        public BlockEntity getBlockEntity() {
            return this.blockEntity;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public PlatformFluidHandler getInternalHandler() {
            return FluidHooks.getBlockFluidManager((BlockEntity)this.getBlockEntity(), (Direction)this.getDirection());
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().insertFluid(fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().extractFluid(fluid, simulate);
        }

        public int getTankAmount() {
            return this.getInternalHandler().getTankAmount();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getInternalHandler().getFluidInTank(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            ArrayList<FluidHolder> list = new ArrayList<FluidHolder>();
            for (int i = 0; i < this.getTankAmount(); ++i) {
                list.add(this.getFluidInTank(i));
            }
            return list;
        }

        public long getTankCapacity(int tank) {
            return this.getInternalHandler().getTankCapacity(tank);
        }
    }

    public static class UniveralFluidContainerHandler
    extends UniveralFluidHandler {
        private final FluidContainer container;

        public UniveralFluidContainerHandler(FluidContainer container) {
            this.container = container;
        }

        public FluidContainer getContainer() {
            return this.container;
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getContainer().insertFluid(fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getContainer().extractFluid(fluid, simulate);
        }

        public int getTankAmount() {
            return this.getContainer().getSize();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getFluidTanks().get(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            return this.getContainer().getFluids();
        }

        public long getTankCapacity(int tank) {
            return this.getContainer().getTankCapacity(tank);
        }
    }
}

